package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;

import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/15 <br/>
 */
public class JarMultiJniApiVhsmManager {

    private static JarMultiJniApiVhsmManager instance;

    private JarMultiJniApiVhsmManager() {

    }

    public static JarMultiJniApiVhsmManager getInstance() {
        if (instance == null) {
            synchronized (JarMultiJniApiVhsmManager.class) {
                if (instance == null) {
                    instance = new JarMultiJniApiVhsmManager();
                }
            }
        }
        return instance;
    }

    /**
     * 创建默认虚拟卡
     *
     * @param context
     * @return
     */
    public Pair<Integer, Pair<JniApiParam, JarJniApiProxy>> createDefaultVhsm(Context context) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create(RET_GET_BINDER_FAIL, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_CreateDefaultVhsm);
        try {
            Bundle result = multiBinder.callMethod(bundle);
            result.setClassLoader(JniApiParam.class.getClassLoader());
            if (result == null) {
                return Pair.create(JarMultiJniApiErrorCode.RET_EXCEPTION, null);
            }
            int ret = result.getInt(ParamKeywords.KEY_int_ret);
            if (ret != 0) {
                return Pair.create(ret, null);
            }
            JniApiParam jniApiParam = result.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);
            final IBinder binder = result.getBinder(ParamKeywords.KEY_Binder_Binder);
            JarJniApiTypeProxy proxy = new JarJniApiTypeProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.chipType);
            return Pair.create(ret, Pair.create(jniApiParam, (JarJniApiProxy) proxy));
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return Pair.create(JarMultiJniApiErrorCode.RET_EXCEPTION, null);
    }
}
