package com.xdja.multichip.jniapi;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.IGetMultiJniApi;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/15 <br/>
 */
public class JarMultiJniApiVhsmManager {

    private static JarMultiJniApiVhsmManager instance;

    private static final String KEY_RET = "ret";
    private static final String KEY_METHOD = "method";

    private JarMultiJniApiVhsmManager() {

    }

    public static JarMultiJniApiVhsmManager getInstance() {
        if (instance == null) {
            synchronized (JarMultiJniApiVhsmManager.class) {
                if (instance == null) {
                    instance = new JarMultiJniApiVhsmManager();
                }
            }
        }
        return instance;
    }

    /**
     * 创建默认虚拟卡
     *
     * @param context
     * @return
     */
    public Pair<Integer, Pair<JniApiParam, JarJniApiProxy>> createDefaultVhsm(Context context) {
        IGetMultiJniApi multiBinder = JarMultiJniApiManager.getInstance().getGetMultiJniApiBinder(context);
        if (multiBinder == null) {
            return Pair.create(RET_GET_BINDER_FAIL, null);
        }
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_CreateDefaultVhsm);
        try {
            Bundle result = multiBinder.callMethod(bundle);
            if (result == null) {
                return Pair.create(JarMultiJniApiErrorCode.RET_EXCEPTION, null);
            }
            result.setClassLoader(JniApiParam.class.getClassLoader());
            int ret = result.getInt(ParamKeywords.KEY_int_ret);
            if (ret != 0) {
                return Pair.create(ret, null);
            }
            JniApiParam jniApiParam = result.getParcelable(ParamKeywords.KEY_Parcelable_JniApiParam);
            final IBinder binder = result.getBinder(ParamKeywords.KEY_Binder_Binder);
            JarJniApiTypeProxy proxy = new JarJniApiTypeProxy(context, IMultiJniApi.Stub.asInterface(binder), jniApiParam.chipType);
            return Pair.create(ret, Pair.create(jniApiParam, (JarJniApiProxy) proxy));
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return Pair.create(JarMultiJniApiErrorCode.RET_EXCEPTION, null);
    }

    /**
     * 贴膜卡SM4,目前接口不支持CBC模式
     *
     * @param proxy
     * @param dataIn 要加密或解密的数据（填充过的且长度是16的倍数）
     * @param flag   加密模式
     * @param kID    加密用0x08，解密用0x09
     * @param IV     初始向量，当CBC_MODE时需要
     * @return
     */
    public int SM4(JarJniApiProxy proxy, byte[] dataIn, int dataLen, int flag, byte[] dataOut,
                   byte kID, byte[] IV) {
        if (proxy == null || dataIn == null || dataIn.length < dataLen || dataOut == null ||
                dataOut.length < dataLen) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        if (IV != null && IV.length != 16){
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }

        Bundle extras = new Bundle();
        extras.putString(KEY_METHOD, "SM4");
        extras.putByteArray("dataIn", dataIn);
        extras.putInt("dataLen", dataLen);
        extras.putInt("flag", flag);
        extras.putByte("kID", kID);
        extras.putByteArray("IV", IV);

        Bundle bundle = proxy.callMethod(extras);
        if (bundle == null) {
            return JarMultiJniApiErrorCode.RET_PARAM_ERROR;
        }
        int ret = bundle.getInt(KEY_RET);
        byte[] dataOutTmp = null;
        if (ret == JNIAPI.XKR_OK) {
            dataOutTmp = bundle.getByteArray("dataOut");
            System.arraycopy(dataOutTmp,0,dataOut,0,dataOutTmp.length);
            byte [] IVTmp = bundle.getByteArray("IV");
            if (IVTmp != null && IV != null){
                System.arraycopy(IVTmp,0,IV,0,IVTmp.length);
            }
        }
        return ret;
    }
}
