package com.xdja.multichip.param;

import android.os.Bundle;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/4/26 <br/>
 */
public class CertBean {

    /**
     * 缺少参数
     */
    public static final int PARAM_LACK = -2001;

    /**
     * 不支持的版本号
     */
    public static final int NOT_SUPPORT_VERSION = -2002;

    /**
     * 参数错误
     */
    public static final int PARAM_ERROR = -2003;

    /**
     * PIN码错误
     */
    public static final int PIN_ERROR = -2004;

    /**
     * 创建容器失败
     */
    public static final int CREATE_CONTAINER_ERROR = -2005;

    /**
     * 不支持的算法
     */
    public static final int NOT_SUPPORT_ALG = -2006;

    /**
     * 更新容器信息失败
     */
    public static final int UPDATE_CONTAINER_ERROR = -2007;

    /**
     * 写交换公钥失败
     */
    public static final int WRITE_EXCHANGE_PUBKEY_ERROR = -2008;

    /**
     * 写交换私钥失败
     */
    public static final int WRITE_EXCHANGE_PRIKEY_ERROR = -2009;

    /**
     * 写交换证书失败
     */
    public static final int WRITE_EXCHANGE_CERT_ERROR = -2010;

    /**
     * 写签名证书失败
     */
    public static final int WRITE_SIGN_CERT_ERROR = -2011;

    /**
     * 解析数据错误
     */
    public static final int ANALYSIS_DATA_ERROR = -2012;

    /**
     * 异常
     */
    public static final int EXCEPTION = -2013;

    public static final String KEY_VERSION_INT = "version";
    public static final String KEY_ROLE_INT = "role";
    public static final String KEY_PIN_STRING = "pin";
    public static final String KEY_CONTAINERNO_INT = "containerNo";
    public static final String KEY_SIGNCERT_BYTEARRAY = "signCert";
    public static final String KEY_EXCHANGECERT_BYTEARRAY = "exchangeCert";
    public static final String KEY_ENVELOPEDKEY_BYTEARRAY = "envelopedKey";
    public static final String KEY_EXCHANGEPUBKEY_BYTEARRAY = "exchangePubKey";
    public static final String KEY_EXCHANGEPRIKEY_BYTEARRAY = "exchangePriKey";
    public static final String KEY_RET_INT = "ret";
    public static final String KEY_INFO_STRING = "info";
    /**
     * 证书类型（单证还是双证）
     * {@link #TYPE_SINGLE_SIGN},{@link #TYPE_DOUBLE},{@link #TYPE_SINGLE_EXCHANGE}
     */
    public static final String KEY_CERTTYPE_INT = "certType";
    /**
     * 证书算法（RSA还是SM2）
     * {@link #ALG_RSA},{@link #ALG_SM2}
     */
    public static final String KEY_CERTALG_INT = "certAlg";

    /**
     * 数据类型（是国密还是普通）
     * {@link #DATA_TYPE_SKF},{@link #DATA_TYPE_NORMAL}
     */
    public static final String KEY_DATATYPE_INT = "dataType";

    public static final int ALG_RSA = 1;
    public static final int ALG_SM2 = 2;

    /**
     * 单证,签名证书
     */
    public static final int TYPE_SINGLE_SIGN = 1;
    /**
     * 双证
     */
    public static final int TYPE_DOUBLE = 2;
    /**
     * 单证,交换证书
     */
    public static final int TYPE_SINGLE_EXCHANGE = 3;


    public static final int DATA_TYPE_SKF = 1;

    /**
     *
     */
    public static final int DATA_TYPE_NORMAL = 2;

    /**
     * 当前版本号
     */
    public static final int VERSION_CUR = 1;

    /**
     * 版本号
     */
    private final int version = VERSION_CUR;
    /**
     * 证书算法
     */
    private int certAlg;
    /**
     * 双证还是单证
     */
    private int certType;
    /**
     * 数据格式
     */
    private int dataType;
    private int role;
    private String pin;
    private int containerNo;
    private byte[] signCert;
    private byte[] exchangeCert;
    private byte[] envelopedKey;
    private byte[] exchangePubKey;
    private byte[] exchangePriKey;

    public int getVersion() {
        return version;
    }

    public int getCertAlg() {
        return certAlg;
    }

    public int getCertType() {
        return certType;
    }

    public int getRole() {
        return role;
    }

    public String getPin() {
        return pin;
    }

    public int getContainerNo() {
        return containerNo;
    }

    public byte[] getSignCert() {
        return signCert;
    }

    public byte[] getExchangeCert() {
        return exchangeCert;
    }

    public byte[] getEnvelopedKey() {
        return envelopedKey;
    }

    public byte[] getExchangePubKey() {
        return exchangePubKey;
    }

    public byte[] getExchangePriKey() {
        return exchangePriKey;
    }

    private CertBean() {

    }


    /**
     * 导入国密SM2双证 所需的数据
     *
     * @param role         导入证书所在容器所需的角色
     * @param pin          角色对应的PIN码
     * @param containerNo  容器号(范围：0 到 9)
     * @param signCert     签名证书
     * @param exchangeCert 交换证书
     * @param envelopedKey 加密的密钥结构体数组
     * @return bean
     */
    public static CertBean createDoubleSM2CertSkf(int role,
                                                  String pin,
                                                  int containerNo,
                                                  byte[] signCert,
                                                  byte[] exchangeCert,
                                                  byte[] envelopedKey) {

        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.exchangeCert = exchangeCert;
        bean.envelopedKey = envelopedKey;
        bean.certAlg = ALG_SM2;
        bean.certType = TYPE_DOUBLE;
        bean.dataType = DATA_TYPE_SKF;
        return bean;
    }

    /**
     * 导入 SM2双证 所需的数据
     *
     * @param role           导入证书所在容器所需的角色
     * @param pin            角色对应的PIN码
     * @param containerNo    容器号(范围：0 到 9)
     * @param signCert       签名证书
     * @param exchangeCert   交换证书
     * @param exchangePubKey 交换公钥
     * @param exchangePriKey 交换私钥
     * @return bean
     */
    public static CertBean createDoubleSM2Cert(int role,
                                               String pin,
                                               int containerNo,
                                               byte[] signCert,
                                               byte[] exchangeCert,
                                               byte[] exchangePubKey,
                                               byte[] exchangePriKey) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.exchangeCert = exchangeCert;
        bean.exchangePubKey = exchangePubKey;
        bean.exchangePriKey = exchangePriKey;
        bean.certAlg = ALG_SM2;
        bean.certType = TYPE_DOUBLE;
        bean.dataType = DATA_TYPE_NORMAL;
        return bean;
    }

    /**
     * SM2单证,签名
     *
     * @param role        导入证书所在容器所需的角色
     * @param pin         角色对应的PIN码
     * @param containerNo 容器号(范围：0 到 9)
     * @param signCert    签名证书
     * @return
     */
    public static CertBean createSingleSM2SignCert(int role,
                                                   String pin,
                                                   int containerNo,
                                                   byte[] signCert) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.certAlg = ALG_SM2;
        bean.certType = TYPE_SINGLE_SIGN;
        bean.dataType = DATA_TYPE_NORMAL;
        return bean;
    }

    /**
     * SM2单证，交换
     *
     * @param role        导入证书所在容器所需的角色
     * @param pin         角色对应的PIN码
     * @param containerNo 容器号(范围：0 到 9)
     * @param signCert    签名证书
     * @return
     */
    public static CertBean createSingleSM2ExchangeCert(int role,
                                                       String pin,
                                                       int containerNo,
                                                       byte[] signCert) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.certAlg = ALG_SM2;
        bean.certType = TYPE_SINGLE_EXCHANGE;
        bean.dataType = DATA_TYPE_NORMAL;
        return bean;
    }


    /**
     * RSA单证
     *
     * @param role        导入证书所在容器所需的角色
     * @param pin         角色对应的PIN码
     * @param containerNo 容器号(范围：0 到 9)
     * @param signCert    签名证书
     * @return
     */
    public static CertBean createSingleRSASignCert(int role,
                                                   String pin,
                                                   int containerNo,
                                                   byte[] signCert) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.certAlg = ALG_RSA;
        bean.certType = TYPE_SINGLE_SIGN;
        bean.dataType = DATA_TYPE_NORMAL;
        return bean;
    }

    /**
     * RSA单证
     *
     * @param role        导入证书所在容器所需的角色
     * @param pin         角色对应的PIN码
     * @param containerNo 容器号(范围：0 到 9)
     * @param signCert    签名证书
     * @return
     */
    public static CertBean createSingleRSAExchangeCert(int role,
                                                       String pin,
                                                       int containerNo,
                                                       byte[] signCert) {
        CertBean bean = new CertBean();
        bean.role = role;
        bean.pin = pin;
        bean.containerNo = containerNo;
        bean.signCert = signCert;
        bean.certAlg = ALG_RSA;
        bean.certType = TYPE_SINGLE_EXCHANGE;
        bean.dataType = DATA_TYPE_NORMAL;
        return bean;
    }

    /**
     * 得到传输所需要的数据
     *
     * @return 数据
     */
    public Bundle getBundle() {
        Bundle bundle = new Bundle();

        bundle.putInt(KEY_VERSION_INT, version);
        bundle.putInt(KEY_CERTALG_INT, certAlg);
        bundle.putInt(KEY_CERTTYPE_INT, certType);
        bundle.putInt(KEY_ROLE_INT, role);
        bundle.putString(KEY_PIN_STRING, pin);
        bundle.putInt(KEY_CONTAINERNO_INT, containerNo);
        bundle.putInt(KEY_DATATYPE_INT, dataType);
        if (signCert != null) {
            bundle.putByteArray(KEY_SIGNCERT_BYTEARRAY, signCert);
        }
        if (exchangeCert != null) {
            bundle.putByteArray(KEY_EXCHANGECERT_BYTEARRAY, exchangeCert);
        }
        if (envelopedKey != null) {
            bundle.putByteArray(KEY_ENVELOPEDKEY_BYTEARRAY, envelopedKey);
        }
        if (exchangePriKey != null) {
            bundle.putByteArray(KEY_EXCHANGEPUBKEY_BYTEARRAY, exchangePubKey);
        }
        if (exchangePriKey != null) {
            bundle.putByteArray(KEY_EXCHANGEPRIKEY_BYTEARRAY, exchangePriKey);
        }
        return bundle;
    }


    public int getDataType() {
        return dataType;
    }
}
