package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.MAX_IV_LEN;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * typedef struct Struct_BLOCKCIPHERPARAM{
 * BYTE IV[MAX_IV_LEN];   //初始向量
 * ULONG IVLen;           //初始向量长度（按字节计算）
 * ULONG PaddingType;     //填充方法，0表示不填充，1表示按照PKCS#5方式填充
 * ULONG FeedBitLen;      //反馈值得位长度（按位计算）
 * }BLOCKCIPHERPARAM,*PBLOCKCIPHERPARAM;
 */

/**
 * 分组密码参数<p>
 */
public class BlockCipherParam implements Parcelable {
    /**
     * 初始向量
     */
    public byte[] IV = new byte[MAX_IV_LEN];
    /**
     * 初始向量长度（按字节计算）
     */
    public int IVLen;
    /**
     * 填充方法，0表示不填充，1表示按照PKCS#5方式填充
     */
    public int paddingType;
    /**
     * 反馈值的位长度（按位计算）
     */
    public int feedBitLen;

    public BlockCipherParam() {

    }

    protected BlockCipherParam(Parcel in) {
        IV = in.createByteArray();
        IVLen = in.readInt();
        paddingType = in.readInt();
        feedBitLen = in.readInt();
    }

    public static final Creator<BlockCipherParam> CREATOR = new Creator<BlockCipherParam>() {
        @Override
        public BlockCipherParam createFromParcel(Parcel in) {
            return new BlockCipherParam(in);
        }

        @Override
        public BlockCipherParam[] newArray(int size) {
            return new BlockCipherParam[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(IV);
        dest.writeInt(IVLen);
        dest.writeInt(paddingType);
        dest.writeInt(feedBitLen);
    }
}
