package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT8 CHAR;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_DEVINFO{<p>
 * Version     Version;             //数据结构版本号,本结构版本号1.0<p>
 * CHAR        Manufacturer[64];    //设备厂商信息,以 '\0'结束的ASCII字符串<p>
 * CHAR        Issuer[64];          //发行厂商信息,以 '\0'结束的ASCII字符串<p>
 * CHAR        Label[32];           //设备标签,以 '\0'结束的ASCII字符串<p>
 * CHAR        SerialNumber[32];    //序列号,以 '\0'结束的ASCII字符串<p>
 * Version     HWVerison;           //设备硬件版本<p>
 * Version     FirmwareVersion;     //设备本身固件版本<p>
 * ULONG       AlgSymCap;           //分组密码算法标识<p>
 * ULONG       AlgAsymCap;          //非对称密码算法标识<p>
 * ULONG       AlgHashCap;          //密码杂凑算法标识<p>
 * ULONG       DevAuthAlgId;        //设备认证时使用的分组密码算法标识<p>
 * ULONG       TotalSpace;          //设备总空间大小<p>
 * ULONG       FreeSpace;           //用户可用空间大小<p>
 * ULONG       MaxECCBufferSize;    //能够处理的ECC加密数据大小<p>
 * ULONG       MaxBufferSize;       //能够处理的分组运算和杂凑运算的数据大小 <p>
 * BYTE        Reserved[64];        //保留扩展<p>
 * }DevInfo,*PDEVINFO;<p>
 */

/**
 * 设备信息<p>
 */
public class DevInfo implements Parcelable {
    /**
     * 数据结构版本号,本结构版本号1.0
     */
    public Version version = new Version();
    /**
     * 设备厂商信息,以 '\0'结束的ASCII字符串
     */
    public byte[] manufacturer = new byte[64];
    /**
     * 发行厂商信息,以 '\0'结束的ASCII字符串
     */
    public byte[] issuer = new byte[64];
    /**
     * 设备标签,以 '\0'结束的ASCII字符串
     */
    public byte[] label = new byte[32];
    /**
     * 序列号,以 '\0'结束的ASCII字符串
     */
    public byte[] serialNumber = new byte[32];
    /**
     * 设备硬件版本
     */
    public Version hwVerison = new Version();
    /**
     * 设备本身固件版本
     */
    public Version firmwareVersion = new Version();
    /**
     * 分组密码算法标识
     */
    public int algSymCap;
    /**
     * 非对称密码算法标识
     */
    public int algAsymCap;
    /**
     * 密码杂凑算法标识
     */
    public int algHashCap;
    /**
     * 设备认证时使用的分组密码算法标识
     */
    public int devAuthAlgId;
    /**
     * 设备总空间大小
     */
    public int totalSpace;
    /**
     * 用户可用空间大小
     */
    public int freeSpace;
    /**
     * 能够处理的ECC加密数据大小
     */
    public int maxECCBufferSize;
    /**
     * 能够处理的分组运算和杂凑运算的数据大小
     */
    public int maxBufferSize;
    /**
     * 保留扩展
     */
    public byte[] reserved = new byte[64];

    public DevInfo() {

    }

    protected DevInfo(Parcel in) {
        version = in.readParcelable(Version.class.getClassLoader());
        manufacturer = in.createByteArray();
        issuer = in.createByteArray();
        label = in.createByteArray();
        serialNumber = in.createByteArray();
        hwVerison = in.readParcelable(Version.class.getClassLoader());
        firmwareVersion = in.readParcelable(Version.class.getClassLoader());
        algSymCap = in.readInt();
        algAsymCap = in.readInt();
        algHashCap = in.readInt();
        devAuthAlgId = in.readInt();
        totalSpace = in.readInt();
        freeSpace = in.readInt();
        maxECCBufferSize = in.readInt();
        maxBufferSize = in.readInt();
        reserved = in.createByteArray();
    }

    public static final Creator<DevInfo> CREATOR = new Creator<DevInfo>() {
        @Override
        public DevInfo createFromParcel(Parcel in) {
            return new DevInfo(in);
        }

        @Override
        public DevInfo[] newArray(int size) {
            return new DevInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }


    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(version, flags);
        dest.writeByteArray(manufacturer);
        dest.writeByteArray(issuer);
        dest.writeByteArray(label);
        dest.writeByteArray(serialNumber);
        dest.writeParcelable(hwVerison, flags);
        dest.writeParcelable(firmwareVersion, flags);
        dest.writeInt(algSymCap);
        dest.writeInt(algAsymCap);
        dest.writeInt(algHashCap);
        dest.writeInt(devAuthAlgId);
        dest.writeInt(totalSpace);
        dest.writeInt(freeSpace);
        dest.writeInt(maxECCBufferSize);
        dest.writeInt(maxBufferSize);
        dest.writeByteArray(reserved);
    }

    public void readFromParcel(Parcel in) {
        version = in.readParcelable(Version.class.getClassLoader());
        manufacturer = in.createByteArray();
        issuer = in.createByteArray();
        label = in.createByteArray();
        serialNumber = in.createByteArray();
        hwVerison = in.readParcelable(Version.class.getClassLoader());
        firmwareVersion = in.readParcelable(Version.class.getClassLoader());
        algSymCap = in.readInt();
        algAsymCap = in.readInt();
        algHashCap = in.readInt();
        devAuthAlgId = in.readInt();
        totalSpace = in.readInt();
        freeSpace = in.readInt();
        maxECCBufferSize = in.readInt();
        maxBufferSize = in.readInt();
        reserved = in.createByteArray();
    }
}
