package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.ECC_MAX_XCOORDINATE_BITS_LEN;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * * typedef unsigned char UINT8;<p>
 * typedef UINT8 BYTE;<p>
 * <p>
 * typedef struct Struct_ECCSIGNATUREBLOB{
 * BYTE r[ECC_MAX_XCOORDINATE_BITS_LEN/8];       //签名结果的r部分
 * BYTE s[ECC_MAX_XCOORDINATE_BITS_LEN/8];       //签名结果的s部分
 * }ECCSIGNATUREBLOB,*PECCSIGNATUREBLOB;
 */

/**
 * ECC签名数据结构
 */

public class EccSignatureBlob implements Parcelable {
    /**
     * 签名结果的r部分
     */
    public byte[] r = new byte[ECC_MAX_XCOORDINATE_BITS_LEN / 8];
    /**
     * 签名结果的s部分
     */
    public byte[] s = new byte[ECC_MAX_XCOORDINATE_BITS_LEN / 8];

    public EccSignatureBlob() {

    }

    protected EccSignatureBlob(Parcel in) {
        readFromParcel(in);
    }
    public void readFromParcel(Parcel in) {
        r = in.createByteArray();
        s = in.createByteArray();
    }

        public static final Creator<EccSignatureBlob> CREATOR = new Creator<EccSignatureBlob>() {
        @Override
        public EccSignatureBlob createFromParcel(Parcel in) {
            return new EccSignatureBlob(in);
        }

        @Override
        public EccSignatureBlob[] newArray(int size) {
            return new EccSignatureBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(r);
        dest.writeByteArray(s);
    }
}
