package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.MAX_RSA_EXPONENT_LEN;
import static com.xdja.skfapi.SkfApiCode.MAX_RSA_MODULUS_LEN;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_RSAPRIVATEKEYBLOB{
 * ULONG AlgID;                              //算法标识号
 * ULONG BitLen;                             //模数的实际位长度,必须是8的倍数
 * BYTE Modulus[MAX_RSA_MODULUS_LEN];        //模数 n = p * q,实际长度为 BitLen/8字节
 * BYTE PublicExponent[MAX_RSA_EXPONENT_LEN];//公开密钥e,一般为010001
 * BYTE PrivateExponent[MAX_RSA_MODULUS_LEN];//私有密钥d,实际长度为BitLen/8字节
 * BYTE Prime1[MAX_RSA_MODULUS_LEN/2];       //素数 p,实际长度为BitLen/16字节
 * BYTE Prime2[MAX_RSA_MODULUS_LEN/2];       //素数 q,实际长度为BitLen/16字节
 * BYTE Prime1Exponent[MAX_RSA_MODULUS_LEN/2];//d mod (p-1)的值,实际长度为BitLen/16字节
 * BYTE Prime2Exponent[MAX_RSA_MODULUS_LEN/2];//d mod (q -1)的值,实际长度为BitLen/16字节
 * BYTE Coefficient[MAX_RSA_MODULUS_LEN/2];   //q模p的乘法逆元,实际长度为BitLen/16字节
 * }RSAPRIVATEKEYBLOB, *PRSAPRIVATEKEYBLOB;
 */

/**
 * RSA私钥数据结构<p>
 */

public class RsaPrivateKeyBlob implements Parcelable {
    /**
     * 算法标识号
     */
    public int algID;
    /**
     * 模数的实际位长度,必须是8的倍数
     */
    public int bitLen;
    /**
     * 模数 n = p * q,实际长度为 BitLen/8字节
     */
    public byte[] modulus = new byte[MAX_RSA_MODULUS_LEN];
    /**
     * 公开密钥e,一般为010001
     */
    public byte[] publicExponent = new byte[MAX_RSA_EXPONENT_LEN];
    /**
     * 私有密钥d,实际长度为BitLen/8字节
     */
    public byte[] privateExponent = new byte[MAX_RSA_MODULUS_LEN];
    /**
     * 素数p,实际长度为BitLen/16字节
     */
    public byte[] prime1 = new byte[MAX_RSA_MODULUS_LEN / 2];
    /**
     * 素数q,实际长度为BitLen/16字节
     */
    public byte[] prime2 = new byte[MAX_RSA_MODULUS_LEN / 2];
    /**
     * d mod (p-1)的值,实际长度为BitLen/16字节
     */
    public byte[] prime1Exponent = new byte[MAX_RSA_MODULUS_LEN / 2];
    /**
     * d mod (q -1)的值,实际长度为BitLen/16字节
     */
    public byte[] prime2Exponent = new byte[MAX_RSA_MODULUS_LEN / 2];
    /**
     * q模p的乘法逆元,实际长度为BitLen/16字节
     */
    public byte[] coefficient = new byte[MAX_RSA_MODULUS_LEN / 2];

    public RsaPrivateKeyBlob() {

    }

    protected RsaPrivateKeyBlob(Parcel in) {
        readFromParcel(in);
    }

    public static final Creator<RsaPrivateKeyBlob> CREATOR = new Creator<RsaPrivateKeyBlob>() {
        @Override
        public RsaPrivateKeyBlob createFromParcel(Parcel in) {
            return new RsaPrivateKeyBlob(in);
        }

        @Override
        public RsaPrivateKeyBlob[] newArray(int size) {
            return new RsaPrivateKeyBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(algID);
        dest.writeInt(bitLen);
        dest.writeByteArray(modulus);
        dest.writeByteArray(publicExponent);
        dest.writeByteArray(privateExponent);
        dest.writeByteArray(prime1);
        dest.writeByteArray(prime2);
        dest.writeByteArray(prime1Exponent);
        dest.writeByteArray(prime2Exponent);
        dest.writeByteArray(coefficient);
    }

    public void readFromParcel(Parcel in){
        algID = in.readInt();
        bitLen = in.readInt();
        modulus = in.createByteArray();
        publicExponent = in.createByteArray();
        privateExponent = in.createByteArray();
        prime1 = in.createByteArray();
        prime2 = in.createByteArray();
        prime1Exponent = in.createByteArray();
        prime2Exponent = in.createByteArray();
        coefficient = in.createByteArray();
    }
}
