package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.ECC_MAX_XCOORDINATE_BITS_LEN;
import static com.xdja.skfapi.SkfApiCode.ECC_MAX_YCOORDINATE_BITS_LEN;
/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_ECCCIPHERBLOB{
 * BYTE XCoordinate[ECC_MAX_XCOORDINATE_BITS_LEN/8];//与y组成椭圆曲线上的点(x,y)
 * BYTE YCoordinate[ECC_MAX_YCOORDINATE_BITS_LEN/8];//
 * BYTE HASH[32];                                   //密文的杂凑值
 * ULONG CipherLen;                                 //密文数据长度
 * BYTE Cipher[1];                                  //密文数据,实际长度为CipherLen
 * }ECCCIPHERBLOB,*PECCCIPHERBLOB;
 */

/**
 * ECC密文数据结构
 */
public class EccCipherBlob implements Parcelable {
    /**
     * 与y组成椭圆曲线上的点(x,y)
     */
    public byte[] xXCoordinate = new byte[ECC_MAX_XCOORDINATE_BITS_LEN / 8];
    /**
     * 与x组成椭圆曲线上的点(x,y)
     */
    public byte[] yCoordinate = new byte[ECC_MAX_YCOORDINATE_BITS_LEN / 8];
    /**
     * 密文的杂凑值
     */
    public byte[] hash = new byte[32];
    /**
     * 密文数据长度
     */
    public int cipherLen;
    /**
     * 密文数据,实际长度为cipherLen
     */
    public byte[] cipher = new byte[1];


    public EccCipherBlob() {

    }

    protected EccCipherBlob(Parcel in) {
        readFromParcel(in);
    }

    public static final Creator<EccCipherBlob> CREATOR = new Creator<EccCipherBlob>() {
        @Override
        public EccCipherBlob createFromParcel(Parcel in) {
            return new EccCipherBlob(in);
        }

        @Override
        public EccCipherBlob[] newArray(int size) {
            return new EccCipherBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }


    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(xXCoordinate);
        dest.writeByteArray(yCoordinate);
        dest.writeByteArray(hash);
        dest.writeInt(cipherLen);
        dest.writeByteArray(cipher);
    }

    public void readFromParcel(Parcel in) {
        xXCoordinate = in.createByteArray();
        yCoordinate = in.createByteArray();
        hash = in.createByteArray();
        cipherLen = in.readInt();
        cipher = in.createByteArray();
    }
}
