package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.ECC_MAX_MODULUS_BITS_LEN;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * typedef struct Struct_ECCPRIVATEKEYBLOB{
 * ULONG BitLen;                               //模数的实际位长度
 * BYTE PrivateKey[ECC_MAX_MODULUS_BITS_LEN/8];  //私有密钥
 * }ECCPRIVATEKEYBLOB,*PECCPRIVATEKEYBLOB;
 */

/**
 * ECC私钥数据结构<p>
 */
public class EccPrivateKeyBlob implements Parcelable {
    /**
     * 模数的实际位长度
     */
    public int bitLen;
    /**
     * 私有密钥
     */
    public byte[] privateKey = new byte[ECC_MAX_MODULUS_BITS_LEN / 8];

    public EccPrivateKeyBlob() {

    }

    protected EccPrivateKeyBlob(Parcel in) {
        readFromParcel(in);
    }

    public static final Creator<EccPrivateKeyBlob> CREATOR = new Creator<EccPrivateKeyBlob>() {
        @Override
        public EccPrivateKeyBlob createFromParcel(Parcel in) {
            return new EccPrivateKeyBlob(in);
        }

        @Override
        public EccPrivateKeyBlob[] newArray(int size) {
            return new EccPrivateKeyBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(bitLen);
        dest.writeByteArray(privateKey);
    }

    public void readFromParcel(Parcel in) {
        bitLen = in.readInt();
        privateKey = in.createByteArray();
    }
}
