package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.ECC_MAX_XCOORDINATE_BITS_LEN;
import static com.xdja.skfapi.SkfApiCode.ECC_MAX_YCOORDINATE_BITS_LEN;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_ECCPUBLICKEYBLOB{
 * ULONG BitLen;                                  //模数的实际位长度
 * BYTE XCoordinate[ECC_MAX_XCOORDINATE_BITS_LEN/8];//曲线上X的坐标 , 约定：SM2数据结构长64字节,有效位后32字节
 * BYTE YCoordinate[ECC_MAX_YCOORDINATE_BITS_LEN/8];//曲线上Y的坐标
 * }ECCPUBLICKEYBLOB,*PECCPUBLICKEYBLOB;
 */

/**
 * ECC公钥数据结构<p>
 */
public class EccPublicKeyBlob implements Parcelable {
    /**
     * 模数的实际位长度
     */
    public int bitLen;
    /**
     * 曲线上X的坐标<p>
     * 有限域上的整数，有限域的最大值为：{@link SkfApiCode#ECC_MAX_XCOORDINATE_BITS_LEN}
     */
    public byte[] xCoordinate = new byte[ECC_MAX_XCOORDINATE_BITS_LEN / 8];
    /**
     * 曲线上Y的坐标<p>
     * 有限域上的整数，有限域的最大值为：{@link SkfApiCode#ECC_MAX_XCOORDINATE_BITS_LEN}
     */
    public byte[] yCoordinate = new byte[ECC_MAX_YCOORDINATE_BITS_LEN / 8];

    public EccPublicKeyBlob() {

    }

    protected EccPublicKeyBlob(Parcel in) {
        readFromParcel(in);
    }

    public void readFromParcel(Parcel in) {
        bitLen = in.readInt();
        xCoordinate = in.createByteArray();
        yCoordinate = in.createByteArray();
    }

    public static final Creator<EccPublicKeyBlob> CREATOR = new Creator<EccPublicKeyBlob>() {
        @Override
        public EccPublicKeyBlob createFromParcel(Parcel in) {
            return new EccPublicKeyBlob(in);
        }

        @Override
        public EccPublicKeyBlob[] newArray(int size) {
            return new EccPublicKeyBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(bitLen);
        dest.writeByteArray(xCoordinate);
        dest.writeByteArray(yCoordinate);
    }
}
