package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_ENVELOPEDKEYBLOB{
 * ULONG Version;                    //当前版本为1
 * ULONG ulSymmAlgID;                //对称算法标识，限定ECB模式
 * ULONG ulBits;                     //加密密钥对的密钥位长度
 * BYTE cbEncryptedPriKey[64];       //加密密钥对私钥的密文
 * ECCPUBLICKEYBLOB PubKey;          //加密密钥对的公钥
 * ECCCIPHERBLOB ECCCipherBlob;      //用保护公钥加密的对称密钥密文
 * }ENVELOPEDKEYBLOB,*PENVELOPEDKEYBLOB;
 */

/**
 * ECC加密密钥对保护结构<p>
 */

public class EnvelopedKeyBlob implements Parcelable {
    /**
     * 当前版本为1
     */
    public int version = 1;
    /**
     * 对称算法标识，限定ECB模式
     */
    public int ulSymmAlgID;
    /**
     * 加密密钥对的密钥位长度
     */
    public int ulBits;
    /**
     * 加密密钥对私钥的密文
     */
    public byte[] cbEncryptedPriKey = new byte[64];
    /**
     * 加密密钥对的公钥
     */
    public EccPublicKeyBlob pubKey = new EccPublicKeyBlob();
    /**
     * 用保护公钥加密的对称密钥密文
     */
    public EccCipherBlob eccCipherBlob = new EccCipherBlob();

    public EnvelopedKeyBlob() {

    }

    protected EnvelopedKeyBlob(Parcel in) {
        readFromParcel(in);
    }

    public void readFromParcel(Parcel in) {
        version = in.readInt();
        ulSymmAlgID = in.readInt();
        ulBits = in.readInt();
        cbEncryptedPriKey = in.createByteArray();
        pubKey = in.readParcelable(EccPublicKeyBlob.class.getClassLoader());
        eccCipherBlob = in.readParcelable(EccCipherBlob.class.getClassLoader());
    }

        public static final Creator<EnvelopedKeyBlob> CREATOR = new Creator<EnvelopedKeyBlob>() {
        @Override
        public EnvelopedKeyBlob createFromParcel(Parcel in) {
            return new EnvelopedKeyBlob(in);
        }

        @Override
        public EnvelopedKeyBlob[] newArray(int size) {
            return new EnvelopedKeyBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(version);
        dest.writeInt(ulSymmAlgID);
        dest.writeInt(ulBits);
        dest.writeByteArray(cbEncryptedPriKey);
        dest.writeParcelable(pubKey, flags);
        dest.writeParcelable(eccCipherBlob, flags);
    }
}
