package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 CHAR;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_FILEATTRIBUTE{
 * CHAR   FileName[32];
 * ULONG  FileSize;
 * ULONG  ReadRights;
 * ULONG  WriteRights;
 * }FILEATTRIBUTE,*PFILEATTRIBUTE;
 */

/**
 * 文件属性<p>
 */
public class FileAttribute implements Parcelable{
    /**
     * 文件名，以'\0'结束的ASCII字符串，最大长度为32
     */
    public byte[] fileName = new byte[32];
    /**
     * 文件大小，创建文件时定义的文件大小
     */
    public int fileSize;
    /**
     * 读取权限，读取文件需要的权限<p>
     * 值可参看：{@link SkfApiCode#SECURE_NEVER_ACCOUNT},
     * {@link SkfApiCode#SECURE_ADM_ACCOUNT},
     * {@link SkfApiCode#SECURE_USER_ACCOUNT},
     * {@link SkfApiCode#SECURE_ANYONE_ACCOUNT}
     */
    public int readRights;
    /**
     * 写入权限，写入文件需要的权限<p>
     * 值可参看：{@link SkfApiCode#SECURE_NEVER_ACCOUNT},
     * {@link SkfApiCode#SECURE_ADM_ACCOUNT},
     * {@link SkfApiCode#SECURE_USER_ACCOUNT},
     * {@link SkfApiCode#SECURE_ANYONE_ACCOUNT}
     */
    public int writeRights;

    public FileAttribute(){

    }

    protected FileAttribute(Parcel in) {
        readFromParcel(in);
    }

    public static final Creator<FileAttribute> CREATOR = new Creator<FileAttribute>() {
        @Override
        public FileAttribute createFromParcel(Parcel in) {
            return new FileAttribute(in);
        }

        @Override
        public FileAttribute[] newArray(int size) {
            return new FileAttribute[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(fileName);
        dest.writeInt(fileSize);
        dest.writeInt(readRights);
        dest.writeInt(writeRights);
    }

    public void readFromParcel(Parcel in){
        fileName = in.createByteArray();
        fileSize = in.readInt();
        readRights = in.readInt();
        writeRights = in.readInt();
    }
}
