package com.xdja.skfapi;

import android.os.Parcel;
import android.os.Parcelable;

import static com.xdja.skfapi.SkfApiCode.MAX_RSA_EXPONENT_LEN;
import static com.xdja.skfapi.SkfApiCode.MAX_RSA_MODULUS_LEN;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/3/27 <br/>
 * * typedef unsigned char UINT8;<p>
 * typedef unsigned int  UINT32;<p>
 * typedef UINT8 BYTE;<p>
 * typedef UINT32 ULONG;<p>
 * <p>
 * typedef struct Struct_RSAPUBLICKEYBLOB{
 * ULONG AlgID;                               //算法标识号
 * ULONG BitLen;                              //模数的实际位长度,必须是8的倍数
 * BYTE Modulus[MAX_RSA_MODULUS_LEN];         //模数 n = p * q ,实际长度为BitLen/8字节
 * BYTE PublicExponent[MAX_RSA_EXPONENT_LEN]; //公开密钥 e 一般为 00010001
 * }RSAPUBLICKEYBLOB, *PRSAPUBLICKEYBLOB;
 */

/**
 * RSA公钥数据结构<p>
 */
public class RsaPublicKeyBlob implements Parcelable {
    /**
     * 算法标识号
     */
    public int algID;
    /**
     * 模数的实际位长度,必须是8的倍数
     */
    public int bitLen;
    /**
     * 模数 n = p * q ,实际长度为BitLen/8字节
     */
    public byte[] modulus = new byte[MAX_RSA_MODULUS_LEN];
    /**
     * 公开密钥e， 一般为 00010001
     */
    public byte[] publicExponent = new byte[MAX_RSA_EXPONENT_LEN];

    public RsaPublicKeyBlob() {

    }

    protected RsaPublicKeyBlob(Parcel in) {
        readFromParcel(in);
    }

    public static final Creator<RsaPublicKeyBlob> CREATOR = new Creator<RsaPublicKeyBlob>() {
        @Override
        public RsaPublicKeyBlob createFromParcel(Parcel in) {
            return new RsaPublicKeyBlob(in);
        }

        @Override
        public RsaPublicKeyBlob[] newArray(int size) {
            return new RsaPublicKeyBlob[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(algID);
        dest.writeInt(bitLen);
        dest.writeByteArray(modulus);
        dest.writeByteArray(publicExponent);
    }

    public void readFromParcel(Parcel in) {
        algID = in.readInt();
        bitLen = in.readInt();
        modulus = in.createByteArray();
        publicExponent = in.createByteArray();
    }
}
