package com.xdja.safekeyservice.status;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/2/8 <br/>
 */

public class StatusClass {
    private Context context;

    private ContentResolver resolver;
    private static final String METHOD_GET_SAFE_CARD_STATUS = "getSafeCardStatus";
    private static final Uri uriObserver = Uri.parse("content://com.xdja.scservice.SafeCardStatusProvider/safeCardStatus");
    private static final Uri uri = Uri.parse("content://com.xdja.scservice.SafeCardStatusProvider");

    /**
     * 能够提供服务
     */
    public static final int STATUS_CAN = 1;
    /**
     * 不能提供服务
     */
    public static final int STATUS_NOT = -1;

    private static final String KEY_STATUS = "status";

    private SafeCardStatusChangeListener listener = null;
    SelfContentObserver observer = null;

    private StatusClass(Context context, SafeCardStatusChangeListener listener) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        resolver = this.context.getContentResolver();
        if (listener != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            observer = new SelfContentObserver(handler, listener);
            context.getContentResolver().registerContentObserver(uriObserver, true, observer);
        }
    }


    /**
     * 获取状态
     *
     * @return
     */
    public int getSafeCardStatus() {
        int status = STATUS_CAN;
        try {
            Bundle result = resolver.call(uri, METHOD_GET_SAFE_CARD_STATUS, "", null);
            status = result.getInt(KEY_STATUS);
        } catch (Exception e) {

        }
        return status;
    }

    /**
     * 取消注册监听
     */
    public void unRegistListener() {
        if (listener != null) {
            context.getContentResolver().unregisterContentObserver(observer);
        }
    }

    public final static class Builder {
        private SafeCardStatusChangeListener listener = null;
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setListener(SafeCardStatusChangeListener listener) {
            this.listener = listener;
            return this;
        }

        public StatusClass build() {
            return new StatusClass(context, listener);
        }
    }


    public interface SafeCardStatusChangeListener {
        void change(int status);
    }

    class SelfContentObserver extends ContentObserver {

        SafeCardStatusChangeListener listener;

        public SelfContentObserver(Handler handler, SafeCardStatusChangeListener listener) {
            super(handler);
            this.listener = listener;
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            super.onChange(selfChange, uri);
            if (listener != null) {
                int status = getSafeCardStatus();
                listener.change(status);
            }
        }
    }

}
