/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safekeyservice.status;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;

public class StatusClass {
    private Context context;
    private ContentResolver resolver;
    private static final String METHOD_GET_SAFE_CARD_STATUS = "getSafeCardStatus";
    private static final Uri uriObserver = Uri.parse((String)"content://com.xdja.scservice.SafeCardStatusProvider/safeCardStatus");
    private static final Uri uri = Uri.parse((String)"content://com.xdja.scservice.SafeCardStatusProvider");
    public static final int STATUS_CAN = 1;
    public static final int STATUS_NOT = -1;
    private static final String KEY_STATUS = "status";
    private SafeCardStatusChangeListener listener = null;
    SelfContentObserver observer = null;

    private StatusClass(Context context, SafeCardStatusChangeListener listener) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.resolver = this.context.getContentResolver();
        if (listener != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            this.observer = new SelfContentObserver(handler, listener);
            context.getContentResolver().registerContentObserver(uriObserver, true, (ContentObserver)this.observer);
        }
    }

    public int getSafeCardStatus() {
        int status = 1;
        try {
            Bundle result = this.resolver.call(uri, METHOD_GET_SAFE_CARD_STATUS, "", null);
            status = result.getInt(KEY_STATUS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    public void unRegistListener() {
        if (this.listener != null) {
            this.context.getContentResolver().unregisterContentObserver((ContentObserver)this.observer);
        }
    }

    class SelfContentObserver
    extends ContentObserver {
        SafeCardStatusChangeListener listener;

        public SelfContentObserver(Handler handler, SafeCardStatusChangeListener listener) {
            super(handler);
            this.listener = listener;
        }

        public void onChange(boolean selfChange, Uri uri) {
            super.onChange(selfChange, uri);
            if (this.listener != null) {
                int status = StatusClass.this.getSafeCardStatus();
                this.listener.change(status);
            }
        }
    }

    public static interface SafeCardStatusChangeListener {
        public void change(int var1);
    }

    public static final class Builder {
        private SafeCardStatusChangeListener listener = null;
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setListener(SafeCardStatusChangeListener listener) {
            this.listener = listener;
            return this;
        }

        public StatusClass build() {
            return new StatusClass(this.context, this.listener);
        }
    }
}

