/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uniteauth.jar;

import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import com.xdja.uniteauth.jar.ExtraParams;
import com.xdja.uniteauth.jar.ICallbackListener;
import com.xdja.uniteauth.jar.RealCallback;

class BundleHandle {
    private static final char COLOR_PREFIX = '#';

    BundleHandle() {
    }

    static Bundle getBundleForGetAuthCode(String random, String cardId, int cardType, ExtraParams extraParams, ICallbackListener listener) {
        Bundle bundle = new Bundle();
        bundle.putString("method", "getAuthCode");
        bundle.putString("random", random);
        if (!TextUtils.isEmpty((CharSequence)cardId)) {
            bundle.putString("cardId", cardId);
        }
        if (cardType > 0) {
            bundle.putInt("cardType", cardType);
        }
        if (extraParams != null) {
            String titleBarColor = extraParams.getTitleBarColor();
            if (!TextUtils.isEmpty((CharSequence)titleBarColor)) {
                if (titleBarColor.charAt(0) != '#') {
                    titleBarColor = '#' + titleBarColor;
                }
                bundle.putString("titleBarColor", titleBarColor);
            }
            String buttonColor = extraParams.getButtonColor();
            if (!TextUtils.isEmpty((CharSequence)extraParams.getButtonColor())) {
                if (buttonColor.charAt(0) != '#') {
                    buttonColor = '#' + buttonColor;
                }
                bundle.putString("buttonColor", buttonColor);
            }
        }
        IBinder callbackBinder = RealCallback.create(listener).getCallbackBinder();
        bundle.putBinder("callbackBinder", callbackBinder);
        return bundle;
    }

    static Bundle getBundleForGetAarPackageName(ExtraParams extraParams) {
        Bundle bundle = new Bundle();
        bundle.putString("method", "get_aar_packageName");
        if (extraParams != null) {
            String titleBarColor = extraParams.getTitleBarColor();
            if (!TextUtils.isEmpty((CharSequence)titleBarColor)) {
                if (titleBarColor.charAt(0) != '#') {
                    titleBarColor = '#' + titleBarColor;
                }
                bundle.putString("titleBarColor", titleBarColor);
            }
            String buttonColor = extraParams.getButtonColor();
            if (!TextUtils.isEmpty((CharSequence)extraParams.getButtonColor())) {
                if (buttonColor.charAt(0) != '#') {
                    buttonColor = '#' + buttonColor;
                }
                bundle.putString("buttonColor", buttonColor);
            }
        }
        return bundle;
    }
}

