/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uniteauth.jar;

import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.xdja.uniteauth.jar.ICallbackListener;
import com.xdja.uniteauth.jar.IRealCallback;

class RealCallback
extends IRealCallback.Stub {
    private ICallbackListener listener;
    private Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (RealCallback.this.listener != null) {
                ReplyBean bean = (ReplyBean)msg.obj;
                RealCallback.this.listener.callback(bean.random, bean.ret, bean.authCode, bean.extra);
            }
        }
    };

    RealCallback(ICallbackListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listener = listener;
    }

    public static RealCallback create(ICallbackListener listener) {
        return new RealCallback(listener);
    }

    public IBinder getCallbackBinder() {
        return this.asBinder();
    }

    @Override
    public void callback(String randomStr, int ret, String authCode, String extra) throws RemoteException {
        Message msg = Message.obtain();
        ReplyBean bean = new ReplyBean();
        bean.random = randomStr;
        bean.ret = ret;
        bean.authCode = authCode;
        bean.extra = extra;
        msg.obj = bean;
        this.handler.sendMessage(msg);
    }

    class ReplyBean {
        String random;
        int ret;
        String authCode;
        String extra;

        ReplyBean() {
        }
    }
}

