/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.uniteauth.jar;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.uniteauth.jar.BundleHandle;
import com.xdja.uniteauth.jar.ExtraParams;
import com.xdja.uniteauth.jar.ICallbackListener;
import com.xdja.uniteauth.jar.IUniteAuth;

public class UniteAuth {
    private static final int JAR_VERSION = 1;
    private Uri uri;
    private IUniteAuth uniteAuthBinder;

    private UniteAuth(Uri uri) {
        this.uri = uri;
    }

    public int getAuthenticationCode(Context context, String randomStr, ICallbackListener listener) {
        return this.getAuthenticationCode(context, randomStr, null, -1, null, listener);
    }

    public int getAuthenticationCode(Context context, String randomStr, ExtraParams extraParams, ICallbackListener listener) {
        return this.getAuthenticationCode(context, randomStr, null, -1, extraParams, listener);
    }

    public int getAuthenticationCode(Context context, String randomStr, String cardId, ICallbackListener listener) {
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new NullPointerException("cardId is null");
        }
        return this.getAuthenticationCode(context, randomStr, cardId, -1, null, listener);
    }

    public int getAuthenticationCode(Context context, String randomStr, String cardId, ExtraParams extraParams, ICallbackListener listener) {
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new NullPointerException("cardId is null");
        }
        return this.getAuthenticationCode(context, randomStr, cardId, -1, extraParams, listener);
    }

    public int getAuthenticationCode(Context context, String randomStr, int cardType, ICallbackListener listener) {
        if (cardType <= 0) {
            return -12;
        }
        return this.getAuthenticationCode(context, randomStr, null, cardType, null, listener);
    }

    public int getAuthenticationCode(Context context, String randomStr, int cardType, ExtraParams extraParams, ICallbackListener listener) {
        if (cardType <= 0) {
            return -12;
        }
        return this.getAuthenticationCode(context, randomStr, null, cardType, extraParams, listener);
    }

    private int getAuthenticationCode(Context context, String randomStr, String cardId, int cardType, ExtraParams extraParams, ICallbackListener listener) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (TextUtils.isEmpty((CharSequence)randomStr)) {
            randomStr = "";
        }
        try {
            IUniteAuth binder = this.getBinder(context);
            if (binder == null) {
                return -4;
            }
            Bundle bundle = BundleHandle.getBundleForGetAuthCode(randomStr, cardId, cardType, extraParams, listener);
            Bundle result = binder.call(bundle);
            return result.getInt("ret");
        }
        catch (ArithmeticException e) {
            try {
                return Integer.valueOf(e.getMessage());
            }
            catch (Exception exception) {
                return -1;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private synchronized IUniteAuth getBinder(Context context) {
        Bundle bundle;
        if (this.uniteAuthBinder != null) {
            return this.uniteAuthBinder;
        }
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle extra = new Bundle();
        extra.putInt("version", 1);
        try {
            bundle = resolver.call(this.uri, "GetBinder", "UniteAuthBinder", extra);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (bundle == null) {
            return null;
        }
        int ret = bundle.getInt("ret");
        if (ret != 0) {
            throw new ArithmeticException("" + ret);
        }
        IBinder binder = bundle.getBinder("Binder");
        if (binder == null) {
            return null;
        }
        this.uniteAuthBinder = IUniteAuth.Stub.asInterface(binder);
        try {
            binder.linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    UniteAuth.this.uniteAuthBinder = null;
                }
            }, 0);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.uniteAuthBinder;
    }

    public int getAuthenticationCodeSync(Context context, String randomStr, ICallbackListener listener) {
        return this.getAuthenticationCodeByStartActivity(context, randomStr, null, -1, null, listener);
    }

    public int getAuthenticationCodeSync(Context context, String randomStr, ExtraParams extraParams, ICallbackListener listener) {
        return this.getAuthenticationCodeByStartActivity(context, randomStr, null, -1, extraParams, listener);
    }

    public int getAuthenticationCodeSync(Context context, String randomStr, String cardId, ExtraParams extraParams, ICallbackListener listener) {
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            throw new NullPointerException("cardId is null");
        }
        return this.getAuthenticationCodeByStartActivity(context, randomStr, cardId, -1, extraParams, listener);
    }

    public int getAuthenticationCodeSync(Context context, String randomStr, int cardType, ExtraParams extraParams, ICallbackListener listener) {
        if (cardType <= 0) {
            return -12;
        }
        return this.getAuthenticationCodeByStartActivity(context, randomStr, null, cardType, extraParams, listener);
    }

    private int getAuthenticationCodeByStartActivity(Context context, String randomStr, String cardId, int cardType, ExtraParams extraParams, ICallbackListener listener) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (TextUtils.isEmpty((CharSequence)randomStr)) {
            randomStr = "";
        }
        try {
            IUniteAuth binder = this.getBinder(context);
            if (binder == null) {
                return -4;
            }
            Bundle result = binder.call(BundleHandle.getBundleForGetAarPackageName(extraParams));
            int getPackageNameRet = result.getInt("ret", -1);
            String arrPackageName = result.getString("pkgName");
            if (getPackageNameRet != 0 || TextUtils.isEmpty((CharSequence)arrPackageName)) {
                Log.d((String)"AuthJar", (String)"arrPackageName is null");
                return -4;
            }
            Bundle bundle = BundleHandle.getBundleForGetAuthCode(randomStr, cardId, cardType, extraParams, listener);
            int uid = Process.myUid();
            int pid = Process.myPid();
            String pkgName = context.getPackageName();
            if (TextUtils.isEmpty((CharSequence)pkgName)) {
                return -5;
            }
            bundle.putInt("uid", uid);
            bundle.putInt("pid", pid);
            bundle.putString("pkgName", pkgName);
            Intent intent = new Intent();
            intent.setClassName(arrPackageName, "com.xdja.uniteauth.presenter.AuthLoginActivity");
            intent.setPackage(arrPackageName);
            intent.putExtra("bundle", bundle);
            if (!(context instanceof Activity)) {
                intent.setFlags(0x10000000);
            }
            context.startActivity(intent);
            return 0;
        }
        catch (ArithmeticException e) {
            try {
                return Integer.valueOf(e.getMessage());
            }
            catch (Exception exception) {
                return -1;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static final class Builder {
        private Uri uri;
        private static final Uri URI_DEFAULT = Uri.parse((String)"content://com.xdja.uniteauth.UniteAuthProvider");

        public Builder baseUri(Uri uri) {
            if (uri == null) {
                throw new NullPointerException("uri is null!");
            }
            this.uri = uri;
            return this;
        }

        public UniteAuth create() {
            if (this.uri == null) {
                this.uri = URI_DEFAULT;
            }
            return new UniteAuth(this.uri);
        }
    }
}

