package com.xdja.xdjacrypto;

/**
 * 证书信息类
 */
public class XCT_CERT_INFO
{
	/**
	 * 拥有者通用名CN
	 */
	public byte[] subjectCN = new byte[128];

	/**
	 * 拥有者更详细信息"C=country, S=province, L=locality, O=organization, OU=organizationalUnit, CN=commonName"
	 */
	public byte[] subjectDN = new byte[256];

	/**
	 * 拥有者组织机构
	 */
	public byte[] subjectOrg = new byte[64];

	/**
	 * 颁发者CN
	 */
	public byte[] issuerCN = new byte[128];

	/**
	 * 颁发者组织机构
	 */
	public byte[] issuerOrg = new byte[128];

	/**
	 * 证书SN [00 00]
	 */
	public byte[] SN = new byte[128];

	/**
	 * 证书有效开始期
	 */
	public byte[] before = new byte[32];

	/**
	 * 证书有效结束期
	 */
	public byte[] after = new byte[32];

	/**
	 * 证书公钥
	 * 
	 */
	public byte[] pubkey = new byte[512];

	/**
	 * 证书公钥长度
	 */
	public int pubkey_len;

	/**
	 * 得到证书公钥长度
	 * 
	 * @return 公钥长度
	 */
	public int getPubkeyLen()
	{
		return pubkey_len;
	}

	/**
	 * 设置 证书公钥长度
	 * @param len 证书公钥长度
     */
	public void setPubkeyLen(int len){
		pubkey_len = len;
	}
}
