/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.filter;

import com.xdja.saps.view.system.auth.service.IAuthService;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTimeoutFilter
extends FormAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(SessionTimeoutFilter.class);
    private final IAuthService authService;

    public SessionTimeoutFilter(IAuthService authService) {
        this.authService = authService;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                if (log.isTraceEnabled()) {
                    log.trace("Login submission detected.  Attempting to execute login.");
                }
                return this.executeLogin(request, response);
            }
            if (log.isTraceEnabled()) {
                log.trace("Login page view.");
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        resp.setHeader("sessionstatus", "timeout");
        resp.setStatus(401);
        this.render(resp, this.authService.unAuthenticationContent());
        return false;
    }

    private void render(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            log.error(String.format("Shiro\u81ea\u5b9a\u4e49\u6743\u9650\u8fc7\u6ee4\u5668\u54cd\u5e94Ajax\u8bf7\u6c42\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", e.getMessage()), (Throwable)e);
        }
    }
}

