/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.realm;

import com.xdja.saps.view.system.auth.service.IAuthService;
import com.xdja.saps.view.system.auth.utils.OperatorUtil;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomShiroRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(CustomShiroRealm.class);
    private final IAuthService authService;

    public CustomShiroRealm(IAuthService authService) {
        this.authService = authService;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String userName = (String)principals.getPrimaryPrincipal();
        List<String> permission = OperatorUtil.getOperator().getPermissions();
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        info.addStringPermissions(permission);
        log.debug("\u8bf7\u6c42\u7684\u7528\u6237 {} \u6743\u9650\u5217\u8868\u4e3a\uff1a{}", (Object)userName, permission);
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        return new SimpleAuthenticationInfo(authToken.getPrincipal(), authToken.getCredentials(), this.getName());
    }
}

