/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.user.utils;

import com.xdja.saps.view.system.auth.bean.Function;
import com.xdja.saps.view.system.user.dto.FunctionUseMenuDTO;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionMenuUtils {
    public static Collection<Function> convertFunction(List<FunctionUseMenuDTO> functionList) {
        LinkedHashMap<Long, Function> parentFunctions = new LinkedHashMap<Long, Function>();
        LinkedHashMap<Long, Function> sonFunctions = new LinkedHashMap<Long, Function>();
        for (FunctionUseMenuDTO dto : functionList) {
            if (null == dto.getParentId() || dto.getParentId() == 0L) {
                parentFunctions.put(dto.getId(), FunctionMenuUtils.functionDTOToFunction(dto));
                continue;
            }
            sonFunctions.put(dto.getId(), FunctionMenuUtils.functionDTOToFunction(dto));
        }
        FunctionMenuUtils.doSort(parentFunctions, sonFunctions);
        return parentFunctions.values();
    }

    private static void doSort(Map<Long, Function> parentFunctions, Map<Long, Function> sonFunctions) {
        Set<Long> integers = sonFunctions.keySet();
        for (Long next : integers) {
            Function sonFunction = sonFunctions.get(next);
            Long parentId = sonFunction.getParentId();
            if (parentFunctions.containsKey(parentId)) {
                parentFunctions.get(parentId).addChildren(sonFunction);
                continue;
            }
            HashMap<Long, Function> sonMap = new HashMap<Long, Function>();
            sonMap.put(next, sonFunction);
            FunctionMenuUtils.doSort(sonFunctions, sonMap);
        }
    }

    private static Function functionDTOToFunction(FunctionUseMenuDTO function) {
        Function item = new Function();
        item.setName(function.getName());
        item.setObjName(function.getObjName());
        item.setIcon(function.getIcon());
        item.setLink(function.getLink());
        item.setOrder(function.getOrderNum());
        item.setApi(function.getIcon());
        item.setPermission(function.getPermissionKey());
        item.setId(function.getId());
        item.setParentId(function.getParentId());
        return item;
    }
}

