/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.config;

import com.xdja.saps.view.system.auth.bean.Function;
import com.xdja.saps.view.system.auth.config.SapsShiroConfig;
import com.xdja.saps.view.system.auth.filter.CustomAuthorizationFilter;
import com.xdja.saps.view.system.auth.filter.KickOutSessionFilter;
import com.xdja.saps.view.system.auth.filter.SessionTimeoutFilter;
import com.xdja.saps.view.system.auth.realm.CustomShiroRealm;
import com.xdja.saps.view.system.auth.service.IAuthService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.MemorySessionDAO;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SapsShiroConfig {
    private static final Logger log = LoggerFactory.getLogger(SapsShiroConfig.class);
    public static final String SHIRO_SESSION_KEY = "shiro-kickout-session";
    @Value(value="${session.expires:30}")
    private Integer sessionTimeout;
    private final IAuthService authService;

    public SapsShiroConfig(IAuthService authService) {
        this.authService = authService;
    }

    @Bean
    public CustomShiroRealm customShiroRealm() {
        return new CustomShiroRealm(this.authService);
    }

    @Bean
    public SessionManager sessionManager(@Autowired SessionDAO sessionDAO, @Autowired Cookie cookieDAO, @Autowired CacheManager cacheManager) {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionDAO(sessionDAO);
        sessionManager.setGlobalSessionTimeout((long)(this.sessionTimeout * 60) * 1000L);
        sessionManager.setSessionIdCookie(cookieDAO);
        ArrayList<1> listener = new ArrayList<1>();
        listener.add(new /* Unavailable Anonymous Inner Class!! */);
        sessionManager.setSessionListeners(listener);
        return sessionManager;
    }

    @Bean
    public SessionDAO sessionDAO() {
        return new MemorySessionDAO();
    }

    @Bean
    public CacheManager cacheManager() {
        return new MemoryConstrainedCacheManager();
    }

    @Bean
    public Cookie cookieDAO() {
        SimpleCookie cookie = new SimpleCookie();
        cookie.setName("WEBSID");
        return cookie;
    }

    @Bean
    public SecurityManager securityManager(@Autowired SessionManager sessionManager) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm((Realm)this.customShiroRealm());
        securityManager.setSessionManager(sessionManager);
        return securityManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(@Autowired CacheManager cacheManager, @Autowired SecurityManager securityManager) {
        log.info("==>\u5f00\u59cb\u52a0\u8f7dShiro\u6743\u9650");
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("authc", new SessionTimeoutFilter(this.authService));
        filters.put("kickout", new KickOutSessionFilter(cacheManager, (SessionManager)securityManager, this.authService));
        filters.put("perms", new CustomAuthorizationFilter(this.authService));
        shiroFilterFactoryBean.setFilters(filters);
        LinkedHashMap<String, String> filterChainDefinitions = new LinkedHashMap<String, String>();
        Collection whiteLinks = this.authService.getWhiteLink();
        if (null != whiteLinks && !whiteLinks.isEmpty()) {
            for (String link : whiteLinks) {
                filterChainDefinitions.put(link, "anon");
            }
        }
        this.processPermission(filterChainDefinitions, this.authService.getFunctions());
        filterChainDefinitions.put("/**", "kickout, authc, perms");
        if (log.isDebugEnabled()) {
            log.debug("\u7cfb\u7edf\u5df2\u52a0\u8f7d\u6743\u9650\u5217\u8868\u4e3a\uff1a{}", filterChainDefinitions);
        }
        log.info("\u7cfb\u7edf\u5df2\u52a0\u8f7d\u6743\u9650\u5217\u8868\u4e3a\uff1a{}", filterChainDefinitions);
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitions);
        log.info("==>Shiro\u6743\u9650\u52a0\u8f7d\u5b8c\u6210");
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(@Autowired SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    private void processPermission(Map<String, String> filterChainDefinitions, Collection<Function> functions) {
        if (null != functions && !functions.isEmpty()) {
            for (Function function : functions) {
                if (!StringUtils.isNotBlank((CharSequence)function.getApi()) || !StringUtils.isNotBlank((CharSequence)function.getPermission())) continue;
                filterChainDefinitions.put(function.getApi(), "perms[" + function.getPermission() + "], kickout, authc");
            }
        }
    }
}

