/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.auth.filter;

import com.xdja.saps.view.system.auth.service.IAuthService;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAuthorizationFilter
extends PermissionsAuthorizationFilter {
    private static final Logger log = LoggerFactory.getLogger(CustomAuthorizationFilter.class);
    private final IAuthService IAuthService;

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        resp.setStatus(401);
        this.render(resp, this.IAuthService.unAuthenticationContent());
        return false;
    }

    private boolean isAjaxRequest(HttpServletRequest req) {
        return req.getHeader("x-requested-with") != null && req.getHeader("x-requested-with").equalsIgnoreCase("XMLHttpRequest");
    }

    private void render(HttpServletResponse response, String text) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        try {
            response.getWriter().write(text);
        }
        catch (IOException e) {
            log.error(String.format("Shiro\u81ea\u5b9a\u4e49\u6743\u9650\u8fc7\u6ee4\u5668\u54cd\u5e94Ajax\u8bf7\u6c42\u5185\u5bb9\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s", e.getMessage()), (Throwable)e);
        }
    }

    public CustomAuthorizationFilter(IAuthService IAuthService2) {
        this.IAuthService = IAuthService2;
    }
}

