/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.dir.controller;

import com.xdja.saps.view.system.dir.service.IDeviceDirService;
import com.xdja.saps.view.system.dir.vo.AddDeviceDirVo;
import com.xdja.saps.view.system.dir.vo.UpdateDeviceDirVo;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class DeviceDirController {
    private static final Logger log = LoggerFactory.getLogger(DeviceDirController.class);
    private final IDeviceDirService deviceDirService;

    @PostMapping(value={"/v1/devicedir/add"})
    public void addDeviceDir(@Validated @RequestBody AddDeviceDirVo deviceDirVo) {
        this.deviceDirService.insertDeviceDir(deviceDirVo);
    }

    @PostMapping(value={"/v1/devicedir/update"})
    public void updateDeviceDir(@Validated @RequestBody UpdateDeviceDirVo updateDeviceDirVo) {
        this.deviceDirService.updateDeviceDir(updateDeviceDirVo);
    }

    @DeleteMapping(value={"/v1/devicedir/del/{id}"})
    public void deleteDeviceDir(@PathVariable Long id) {
        this.deviceDirService.deleteDeviceDir(id);
    }

    @RequestMapping(value={"/v1/devicedir/list"}, method={RequestMethod.GET})
    public Object listDeviceDir() {
        return this.deviceDirService.listDeviceDir();
    }

    @GetMapping(value={"/v1/devicedir/details/{id}"})
    public Object getDeviceDir(@PathVariable Long id) {
        return this.deviceDirService.getDeviceDir(id);
    }

    @PostMapping(value={"/v1/devicedir/import"})
    public void execlImport(@RequestParam MultipartFile file, HttpServletResponse resp) throws Exception {
        this.deviceDirService.doExcelImport(file);
    }

    public DeviceDirController(IDeviceDirService deviceDirService) {
        this.deviceDirService = deviceDirService;
    }
}

