/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.superiorPlatform.controller;

import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.system.superiorPlatform.service.ISuperiorPlatformService;
import com.xdja.saps.view.system.superiorPlatform.vo.SuperiorPlatformVo;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/platform"})
public class SuperiorPlatformController {
    private final ISuperiorPlatformService superiorPlatformService;

    @GetMapping(value={"/list"})
    public Object listPlatformPage(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        return this.superiorPlatformService.listPlatformInfoPage(pageNo, pageSize);
    }

    @GetMapping(value={"/detail"})
    public Object getPlatformDetail(@RequestParam Long id) {
        return this.superiorPlatformService.getDetail(id);
    }

    @PostMapping(value={"/add"})
    public Object addPlatform(@Validated @RequestBody SuperiorPlatformVo superiorPlatformVo) {
        this.superiorPlatformService.savePlatformInfo(superiorPlatformVo);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    public Object modifyPlatform(@Validated @RequestBody SuperiorPlatformVo superiorPlatformVo) {
        this.superiorPlatformService.modifyPlatformInfo(superiorPlatformVo);
        return Result.success();
    }

    @DeleteMapping(value={"/del/{id}"})
    public Object deletePlatformDetail(@PathVariable Long id) {
        this.superiorPlatformService.deletePlatformInfo(id);
        return Result.success();
    }

    public SuperiorPlatformController(ISuperiorPlatformService superiorPlatformService) {
        this.superiorPlatformService = superiorPlatformService;
    }
}

