/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.superiorPlatform.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xdja.saps.view.common.core.bean.PageInfo;
import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.common.core.enums.ErrorEnum;
import com.xdja.saps.view.common.core.exception.ServiceException;
import com.xdja.saps.view.common.http.SapsViewHttpClient;
import com.xdja.saps.view.common.http.bean.HttpResult;
import com.xdja.saps.view.system.config.SapsViewPlatformConfig;
import com.xdja.saps.view.system.superiorPlatform.converter.SuperiorPlatformConverter;
import com.xdja.saps.view.system.superiorPlatform.entity.SuperiorPlatformInfoEntity;
import com.xdja.saps.view.system.superiorPlatform.repository.ISuperiorPlatformRepository;
import com.xdja.saps.view.system.superiorPlatform.service.ISuperiorPlatformService;
import com.xdja.saps.view.system.superiorPlatform.vo.SuperPlatFormDto;
import com.xdja.saps.view.system.superiorPlatform.vo.SuperiorPlatformVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SuperiorPlatformServiceImpl
implements ISuperiorPlatformService {
    private static final Logger log = LoggerFactory.getLogger(SuperiorPlatformServiceImpl.class);
    private final ISuperiorPlatformRepository superiorPlatformRepository;
    private final SapsViewHttpClient httpClient;
    private final SapsViewPlatformConfig sapsViewPlatformConfig;

    public PageInfo<SuperiorPlatformVo> listPlatformInfoPage(Integer pageNo, Integer pageSize) {
        Page queryPage = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.superiorPlatformRepository.page((IPage)queryPage);
        List resultList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)queryPage.getRecords())) {
            resultList = SuperiorPlatformConverter.INSTANCE.entityListToVoList(queryPage.getRecords());
        }
        return new PageInfo(queryPage.getPages(), queryPage.getTotal(), resultList);
    }

    public SuperiorPlatformVo getDetail(Long id) {
        SuperiorPlatformInfoEntity platformInfoEntity = (SuperiorPlatformInfoEntity)this.superiorPlatformRepository.getById((Serializable)id);
        if (null == platformInfoEntity) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_NOT_EXISTS);
        }
        return SuperiorPlatformConverter.INSTANCE.entityToVo(platformInfoEntity);
    }

    public void savePlatformInfo(SuperiorPlatformVo superiorPlatformVo) {
        this.checkParamUnique(superiorPlatformVo, true);
        SuperiorPlatformInfoEntity platformInfoEntity = SuperiorPlatformConverter.INSTANCE.voToEntity(superiorPlatformVo);
        this.superiorPlatformRepository.save((Object)platformInfoEntity);
        if (superiorPlatformVo.getEnableState() == 1) {
            this.notifyRegisterToSuper(platformInfoEntity, true);
        }
    }

    public void modifyPlatformInfo(SuperiorPlatformVo superiorPlatformVo) {
        this.checkParamUnique(superiorPlatformVo, false);
        SuperiorPlatformInfoEntity platformInfoEntity = (SuperiorPlatformInfoEntity)this.superiorPlatformRepository.getById((Serializable)superiorPlatformVo.getId());
        if (null == platformInfoEntity) {
            log.error("\u4e0a\u7ea7\u5e73\u53f0\u5df2\u4e0d\u5b58\u5728, Id\uff1a{}", (Object)superiorPlatformVo.getId());
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_NOT_EXISTS);
        }
        platformInfoEntity = SuperiorPlatformConverter.INSTANCE.voToEntity(superiorPlatformVo);
        this.superiorPlatformRepository.updateById((Object)platformInfoEntity);
        this.notifyRegisterToSuper(platformInfoEntity, platformInfoEntity.getEnableState() == 1);
    }

    public void deletePlatformInfo(Long id) {
        SuperiorPlatformInfoEntity platformInfoEntity = (SuperiorPlatformInfoEntity)this.superiorPlatformRepository.getById((Serializable)id);
        if (null == platformInfoEntity) {
            log.error("\u4e0a\u7ea7\u5e73\u53f0\u5df2\u4e0d\u5b58\u5728, Id\uff1a{}", (Object)id);
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_NOT_EXISTS);
        }
        this.superiorPlatformRepository.removeById((Serializable)id);
        if (platformInfoEntity.getEnableState() == 1) {
            this.notifyRegisterToSuper(platformInfoEntity, false);
        }
    }

    private void notifyRegisterToSuper(SuperiorPlatformInfoEntity superiorPlatformInfoEntity, boolean reRegister) {
        try {
            SuperPlatFormDto superPlatFormDto = this.convertFromEntity(superiorPlatformInfoEntity, reRegister);
            HttpResult httpResult = this.httpClient.post(this.sapsViewPlatformConfig.getRegisterUrl(), JSONObject.toJSONString((Object)superPlatFormDto, (JSONWriter.Feature[])new JSONWriter.Feature[0]).getBytes());
            byte[] body = httpResult.getBody();
            if (null == body || body.length == 0) {
                log.error("\u5411\u4e0a\u7ea7\u5e73\u53f0\u66f4\u65b0\u6ce8\u518c\u4fe1\u606f\u5931\u8d25, \u7ed3\u679c\u4e3a\u7a7a");
                throw new ServiceException(ErrorEnum.UPDATE_INFO_TO_SUPERIOR_PLATFORM_FAIL);
            }
            Result result = (Result)JSONObject.parseObject((String)new String(body), Result.class);
            if (result.isError()) {
                log.error("\u5411\u4e0a\u7ea7\u5e73\u53f0\u66f4\u65b0\u6ce8\u518c\u4fe1\u606f\u5931\u8d25, \u7ed3\u679c:{}", (Object)result);
                throw new ServiceException(ErrorEnum.UPDATE_INFO_TO_SUPERIOR_PLATFORM_FAIL);
            }
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u89c6\u56fe\u670d\u52a1\u5411\u4e0a\u7ea7\u5e73\u53f0\u66f4\u65b0\u6ce8\u518c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException(ErrorEnum.UPDATE_INFO_TO_SUPERIOR_PLATFORM_FAIL);
        }
    }

    private SuperPlatFormDto convertFromEntity(SuperiorPlatformInfoEntity entity, boolean reRegister) {
        SuperPlatFormDto superPlatFormDto = new SuperPlatFormDto();
        superPlatFormDto.setId(entity.getId());
        superPlatFormDto.setDeviceId(entity.getDeviceCode());
        superPlatFormDto.setIp(entity.getHighPlatformIp());
        superPlatFormDto.setPort(entity.getHighPlatformPort());
        superPlatFormDto.setUserName(entity.getUserName());
        superPlatFormDto.setPassword(entity.getPassword());
        superPlatFormDto.setReRegister(reRegister);
        return superPlatFormDto;
    }

    private void checkParamUnique(SuperiorPlatformVo superiorPlatformVo, boolean isAdd) {
        Long id;
        Long l = id = isAdd ? null : superiorPlatformVo.getId();
        if (this.superiorPlatformRepository.existDeviceCode(superiorPlatformVo.getDeviceCode(), id)) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_DEVICE_CODE_EXISTS);
        }
        if (this.superiorPlatformRepository.existDeviceField(superiorPlatformVo.getDeviceField(), id)) {
            throw new ServiceException(ErrorEnum.SUPERIOR_PLATFORM_DEVICE_FIELD_EXISTS);
        }
    }

    public SuperiorPlatformServiceImpl(ISuperiorPlatformRepository superiorPlatformRepository, SapsViewHttpClient httpClient, SapsViewPlatformConfig sapsViewPlatformConfig) {
        this.superiorPlatformRepository = superiorPlatformRepository;
        this.httpClient = httpClient;
        this.sapsViewPlatformConfig = sapsViewPlatformConfig;
    }
}

