/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.saps.view.system.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.xdja.saps.view.common.core.bean.Result;
import com.xdja.saps.view.system.auth.utils.OperatorUtil;
import com.xdja.saps.view.system.user.bean.RoleEnumVo;
import com.xdja.saps.view.system.user.bean.forms.FormsVo;
import com.xdja.saps.view.system.user.bean.forms.Meta;
import com.xdja.saps.view.system.user.entity.MenuEntity;
import com.xdja.saps.view.system.user.entity.RoleMenuEntity;
import com.xdja.saps.view.system.user.mapper.FunctionMapper;
import com.xdja.saps.view.system.user.repository.RoleMenuRepository;
import com.xdja.saps.view.system.user.service.FunctionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FunctionServiceImpl
implements FunctionService {
    private static final Logger log = LoggerFactory.getLogger(FunctionServiceImpl.class);
    private final RoleMenuRepository roleMenuRepository;
    private final FunctionMapper functionMapper;

    public Result getRoleMenu(Long roleId) {
        Page roleMenuEntityPage = this.roleMenuRepository.selectRoleMenuPage(roleId.longValue());
        HashMap<String, Integer> roleMenuMap = new HashMap<String, Integer>();
        for (RoleMenuEntity roleMenuEntity : roleMenuEntityPage.getRecords()) {
            roleMenuMap.put(roleMenuEntity.getAlias(), roleMenuEntity.getStatus());
        }
        return Result.success(roleMenuMap);
    }

    public Result saveRoleMenu(RoleEnumVo roleEnumVo) {
        Long roleId = roleEnumVo.getRoleId();
        Page roleMenuEntityPage = this.roleMenuRepository.selectRoleMenuPage(roleId.longValue());
        for (RoleMenuEntity roleMenuEntity : roleMenuEntityPage.getRecords()) {
            String alias = roleMenuEntity.getAlias();
            HashMap enumVo = roleEnumVo.getRoleInfo();
            roleMenuEntity.setStatus((Integer)enumVo.get(alias));
            this.roleMenuRepository.updateById((Object)roleMenuEntity);
        }
        return Result.success();
    }

    public Result getFormsInfo() {
        String loginName = OperatorUtil.getOperatorUserName();
        List menuEntityList = this.functionMapper.selectMenuByLoginName(loginName, 0L);
        ArrayList<FormsVo> fatherVo = new ArrayList<FormsVo>();
        for (MenuEntity menuEntity : menuEntityList) {
            FormsVo formsVo = this.entityToFormsVo(menuEntity);
            fatherVo.add(formsVo);
            List childrenEntity = this.functionMapper.selectMenuByLoginName(loginName, menuEntity.getId().longValue());
            ArrayList<FormsVo> children = new ArrayList<FormsVo>();
            for (MenuEntity entity : childrenEntity) {
                FormsVo childrenVo = this.entityToFormsVo(entity);
                childrenVo.setChildren(new ArrayList());
                children.add(childrenVo);
            }
            formsVo.setChildren(children);
        }
        return Result.success(fatherVo);
    }

    private FormsVo entityToFormsVo(MenuEntity menuEntity) {
        FormsVo formsVo = new FormsVo();
        formsVo.setName(menuEntity.getObjName());
        formsVo.setPath(menuEntity.getLink());
        formsVo.setComponent(menuEntity.getComponent());
        Meta meta = new Meta();
        meta.setIcon(menuEntity.getIcon());
        meta.setTitle(menuEntity.getName());
        meta.setShow(menuEntity.isShow());
        meta.setHasAppend(menuEntity.isHasAppend());
        formsVo.setMeta(meta);
        return formsVo;
    }

    public FunctionServiceImpl(RoleMenuRepository roleMenuRepository, FunctionMapper functionMapper) {
        this.roleMenuRepository = roleMenuRepository;
        this.functionMapper = functionMapper;
    }
}

