/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.api;

import com.xdja.rcs.sc.client.api.CallerAdapter;
import com.xdja.rcs.sc.client.core.config.ScClientConfig;
import com.xdja.rcs.sc.client.core.config.ScClientConfigProxy;
import com.xdja.rcs.sc.client.core.consumer.MessageCallback;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.extension.MessageAdapter;
import com.xdja.sc.client.producer.SuperTransmitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScClientAPI {
    private static final int DEFAULT_CONNECTIONS_COUNT = 3;
    private static final String SEPARATOR = ",";

    public static void initClient(String configFilePath) throws UnrecoverableException {
        if (StringUtils.isBlank((CharSequence)configFilePath)) {
            throw UnrecoverableException.create("\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u53c2\u6570configFilePath\u4e3a\u7a7a");
        }
        ScClientAPI.initClient(new File(configFilePath));
        MQSetting.setThreadSize(3);
    }

    public static void initClient(File configFile) throws UnrecoverableException {
        if (configFile == null) {
            throw UnrecoverableException.create("\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u53c2\u6570configFile\u4e3a\u7a7a");
        }
        try {
            ScClientAPI.initClient(new FileInputStream(configFile));
        }
        catch (FileNotFoundException e) {
            throw UnrecoverableException.create("\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728", e);
        }
    }

    private static void initClient(FileInputStream fileInputStream) throws UnrecoverableException {
        ScClientConfig config = ScClientConfigProxy.initScClientConfig(fileInputStream);
        MQSetting.init(config.getUsername(), config.getPassword(), ScClientAPI.convert(config.getUrls()), config.getApp());
    }

    private static String convert(List<String> urls) {
        return StringUtils.join((Object[])urls.toArray(), (String)SEPARATOR);
    }

    public static void registerMsgCallback(MessageCallback ... msgCallbacks) throws UnrecoverableException {
        try {
            MQSetting.registAction(new CallerAdapter(msgCallbacks), true);
        }
        catch (Exception e) {
            throw UnrecoverableException.create("\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u6ce8\u518c\u5904\u7406\u56de\u8c03\u5931\u8d25\uff1a", e);
        }
    }

    public static void sendMessage(String scServerId, Message message) throws UnrecoverableException, IllegalArgumentException {
        try {
            SuperTransmitter.getInstance().sendMessage(message.getTopicId(), MessageAdapter.convertMessage(message));
        }
        catch (Exception e) {
            throw UnrecoverableException.create("\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a", e);
        }
    }
}

