/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.producer;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.producer.SendTask;
import com.xdja.sc.model.Msg;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class Transmitter {
    private static final int MAX_THREAD_COUNT = 3;
    private static ExecutorService executorService;
    private static Transmitter transmitter;
    private static Logger logger;
    public static Queue<Msg> sendQueue;

    static {
        logger = Logger.getLogger(Transmitter.class);
    }

    private Transmitter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Transmitter getInstance() {
        if (transmitter != null) return transmitter;
        Class<Transmitter> clazz = Transmitter.class;
        synchronized (Transmitter.class) {
            if (transmitter != null) return transmitter;
            transmitter = new Transmitter();
            sendQueue = new ConcurrentLinkedQueue<Msg>();
            executorService = Executors.newFixedThreadPool(3);
            int i = 0;
            while (i < 3) {
                executorService.submit(new SendTask());
                ++i;
            }
            logger.info((Object)"init Transmitter with Thread Count 3");
            // ** MonitorExit[var0] (shouldn't be in output)
            return transmitter;
        }
    }

    public int sendMessage(String topic, Msg msg) {
        msg.type = topic;
        msg.producer = MQSetting.Queue;
        return sendQueue.add(msg) ? 1 : -1;
    }
}

