/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.core.exception;

import java.io.PrintWriter;
import java.io.StringWriter;

public class UnrecoverableException
extends Exception {
    private static final long serialVersionUID = 1476496990517827600L;
    private String message;
    private String className;
    private String method;
    private Throwable preException;

    public static final UnrecoverableException create(String message) {
        return UnrecoverableException.create(message, null);
    }

    public static final UnrecoverableException create(String message, Throwable preException) {
        UnrecoverableException instance = new UnrecoverableException(message, preException);
        for (StackTraceElement stack : instance.getStackTrace()) {
            if (UnrecoverableException.class.getName().equals(stack.getClassName())) continue;
            instance.className = stack.getClassName();
            instance.method = stack.getMethodName();
            break;
        }
        return instance;
    }

    private UnrecoverableException(String message, Throwable preException) {
        super(message, preException);
        this.message = message;
        this.preException = preException;
    }

    public String getStackTraceInfo() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.preException != null) {
            this.preException.printStackTrace(printWriter);
        } else {
            this.printStackTrace(printWriter);
        }
        return stringWriter.getBuffer().toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.method;
    }

    public Throwable getPreException() {
        return this.preException;
    }
}

