/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.consumer;

import com.google.gson.JsonSyntaxException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import com.xdja.sc.codec.Codec;
import com.xdja.sc.codec.CodecFactory;
import com.xdja.sc.model.Msg;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class ReceivedAction
implements Cloneable {
    private static Logger logger = Logger.getLogger(ReceivedAction.class);
    public Codec codec = CodecFactory.getCodec();
    public Codec Msgcodec = CodecFactory.getMsgCodec();

    public abstract void delivery(Msg var1, long var2, Channel var4, boolean var5);

    public void delivery(byte[] body, long deliveryTag, Channel channel, boolean autoAck) {
        block10: {
            try {
                this.delivery(this.codec.deSerialize(body), deliveryTag, channel, autoAck);
            }
            catch (Exception e) {
                logger.error((Object)("Parsing Message Exception ==> [" + new String(body) + "]"));
                System.err.println("Parsing Message Exception ==> [" + new String(body) + "]");
                logger.error((Object)e);
                if (e instanceof JsonSyntaxException) {
                    block9: {
                        try {
                            this.delivery(this.Msgcodec.deSerialize(body), deliveryTag, channel, autoAck);
                        }
                        catch (Exception e1) {
                            logger.error((Object)("Parsing By MsgPack Message Exception ==> [" + new String(body) + "]"));
                            System.err.println("Parsing By MsgPack Message Exception ==> [" + new String(body) + "]");
                            logger.error((Object)e);
                            if (autoAck) break block9;
                            try {
                                channel.basicAck(deliveryTag, true);
                            }
                            catch (IOException ex) {
                                logger.error((Object)ex);
                            }
                        }
                    }
                    return;
                }
                if (autoAck) break block10;
                try {
                    channel.basicNack(deliveryTag, false, true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ReceivedAction clone = (ReceivedAction)super.clone();
        clone.codec = CodecFactory.getCodec();
        return clone;
    }

    public void handleShutdownSingal(String consumerTag, ShutdownSignalException exception) {
    }
}

