/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.core;

import com.rabbitmq.client.Channel;
import com.xdja.rcs.sc.client.core.consumer.MessageCallback;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.client.consumer.Receiver;
import com.xdja.sc.client.core.initChanel;
import com.xdja.sc.model.Msg;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MQSetting {
    public static final String EXCHANGE = "SC_EXCHANGE";
    public static int THREAD_SIZE = 2;
    public static boolean autoAck = false;
    private static Logger logger = Logger.getLogger(MQSetting.class);
    public static String username = null;
    public static String pwd = null;
    public static String url = null;
    public static String Queue = "DefaultQueue";
    private static ExecutorService pool;
    public static ConcurrentHashMap<String, MessageCallback<Msg>> ActionMap;

    public static void init(String loginname, String password, String mq_url, String queue_name) {
        username = loginname;
        pwd = password;
        url = mq_url;
        Queue = queue_name;
        pool = Executors.newFixedThreadPool(THREAD_SIZE);
    }

    public static void initChanel(List<String> topics) throws Exception {
        try (initChanel init = null;){
            init = new initChanel(url, 1);
            init.initTopics(topics);
        }
    }

    public static void setThreadSize(int size) {
        THREAD_SIZE = size;
    }

    public static void setAutoAck(boolean auto_Ack) {
        autoAck = auto_Ack;
    }

    public static void registAction(ReceivedAction action) throws Exception {
        MQSetting.registAction(action, false);
    }

    public static void registerMsgCallback(MessageCallback<Msg> caller) {
        if (!ActionMap.contains(caller.getTopicId())) {
            ActionMap.put(caller.getTopicId(), caller);
        }
    }

    public static void SetMultiCallbackAction() throws Exception {
        MQSetting.registAction(new ReceivedAction(){
            boolean resualt = false;

            @Override
            public void delivery(Msg msg, long deliveryTag, Channel channel, boolean autoAck) {
                if (ActionMap.containsKey(msg.type)) {
                    this.resualt = ActionMap.get(msg.type).process(msg);
                } else {
                    logger.error((Object)("Received Msg but not find Handler == > " + msg));
                }
                if (!autoAck && this.resualt) {
                    try {
                        channel.basicAck(deliveryTag, true);
                        logger.debug((Object)("Handle " + msg + " Successfully."));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static void registAction(ReceivedAction action, boolean isMuti) throws Exception {
        if (isMuti) {
            for (int i = 0; i < THREAD_SIZE; ++i) {
                pool.execute(new Receiver(url, (ReceivedAction)action.clone(), autoAck));
            }
        } else {
            pool.execute(new Receiver(url, (ReceivedAction)action.clone(), autoAck));
        }
        logger.info((Object)"\u6ce8\u518c\u6d88\u606f\u5904\u7406\u4e8b\u4ef6\u6210\u529f");
    }

    static {
        ActionMap = new ConcurrentHashMap();
    }
}

