/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.extension;

import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.extension.FileQueue;
import com.xdja.sc.client.extension.TaskManager;
import com.xdja.sc.client.producer.Sender;
import com.xdja.sc.model.Msg;
import java.net.ConnectException;
import java.util.List;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class RetryTask
extends TimerTask {
    private static Logger logger = Logger.getLogger(RetryTask.class);

    @Override
    public void run() {
        logger.info((Object)("RetryTask running begin at ==> " + System.currentTimeMillis()));
        List<Msg> list = null;
        try {
            list = FileQueue.readMsg();
            int flag = 1;
            if (list.size() > 0) {
                logger.error((Object)("RetryTask reSend Msgs count ==> " + list.size()));
                Sender sender = new Sender(MQSetting.url);
                for (Msg msg : list) {
                    flag = sender.sendMessage(msg.type, msg);
                }
            } else {
                logger.error((Object)"RetryTask reSend Msgs count is ZERO !! ");
            }
            if (flag > 0 && !FileQueue.exists()) {
                TaskManager.getInstance().cancel();
                logger.info((Object)"RetryTask reSend Msgs OK Cancel TaskManager.");
            }
        }
        catch (ConnectException connectione) {
            if (list != null && list.size() > 0) {
                logger.error((Object)"RetryTask reSend Msgs ConnectException ");
                try {
                    FileQueue.writeMsg(list);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)("FileQueue writeMsg Error ==> " + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("RetryTask reSend Msgs Error ==> " + e.getMessage()));
        }
        logger.info((Object)("RetryTask running end at ==> " + System.currentTimeMillis()));
    }
}

