/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sc.client.producer;

import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.ShutdownSignalException;
import com.xdja.sc.client.core.Connnector;
import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.client.extension.FileQueue;
import com.xdja.sc.client.extension.TaskManager;
import com.xdja.sc.codec.Codec;
import com.xdja.sc.codec.CodecFactory;
import com.xdja.sc.model.Msg;
import java.io.IOException;
import java.net.SocketException;
import java.util.List;
import org.apache.log4j.Logger;

public class Sender
extends Connnector {
    private static Logger logger = Logger.getLogger(Sender.class);
    private static final int THREAD_COUNT = 10;
    private Codec codec = CodecFactory.getCodec();

    public Sender(String conStr) throws Exception {
        super(conStr, 10);
        this.channel.confirmSelect();
    }

    public int sendMessage(String topic, Msg msg) throws Exception {
        try {
            msg.type = topic;
            msg.producer = MQSetting.Queue;
            this.channel.basicPublish("SC_EXCHANGE", topic, MessageProperties.PERSISTENT_TEXT_PLAIN, this.convertMsg(msg));
            if (!this.channel.waitForConfirms()) {
                logger.error((Object)("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u6301\u4e45\u5316\u5b58\u50a8\u6d88\u606f" + msg));
                FileQueue.writeMsg(msg);
                if (!TaskManager.getInstance().isStart()) {
                    TaskManager.getInstance().start();
                }
                return -1;
            }
        }
        catch (ShutdownSignalException | SocketException e) {
            logger.error((Object)("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u6301\u4e45\u5316\u5b58\u50a8\u6d88\u606f" + msg));
            e.printStackTrace();
            FileQueue.writeMsg(msg);
            if (!TaskManager.getInstance().isStart()) {
                TaskManager.getInstance().start();
            }
            return -1;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception("\u751f\u4ea7\u6d88\u606f\u53d1\u751f\u4e0d\u53ef\u6062\u590d\u5f02\u5e38:" + e.getMessage());
        }
        logger.debug((Object)("\u5411\u670d\u52a1\u5668\u3010" + topic + "\u3011\u53d1\u51fa\u6d88\u606f ==> " + msg));
        return 1;
    }

    public int sendMessage(String topic, List<Msg> msgs) throws Exception {
        try {
            for (Msg msg : msgs) {
                msg.type = topic;
                this.channel.basicPublish("SC_EXCHANGE", topic, MessageProperties.PERSISTENT_TEXT_PLAIN, this.convertMsg(msg));
            }
            if (!this.channel.waitForConfirms()) {
                logger.error((Object)("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u6279\u91cf\u6301\u4e45\u5316\u5b58\u50a8\u6d88\u606fSIZE : " + msgs.size()));
                FileQueue.writeMsg(msgs);
                if (!TaskManager.getInstance().isStart()) {
                    TaskManager.getInstance().start();
                }
                return -1;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception("\u751f\u4ea7\u6d88\u606f\u53d1\u751f\u4e0d\u53ef\u6062\u590d\u5f02\u5e38:" + e.getMessage());
        }
        logger.debug((Object)("\u5411\u670d\u52a1\u5668\u3010" + topic + "\u3011\u53d1\u51fa\u6d88\u606f ==> " + msgs));
        return 1;
    }

    private byte[] convertMsg(Msg msg) throws IOException {
        return this.codec.serialize(msg);
    }

    public void beginTransaction() throws IOException {
        this.channel.txSelect();
    }

    public void commitTransaction() throws IOException {
        this.channel.txCommit();
    }

    public void rollbackTransaction() throws IOException {
        this.channel.txRollback();
    }
}

