package com.xdja.servicebus.http;
import com.xdja.servicebus.http.api.UrlConverterApi;
import com.xdja.servicebus.utils.UrlConstant;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;


/**
 * @author 袁万里
 * @date 2017/5/31 0031
 */

public class RetrofitFactory {
    public final static long CONNECT_TIMEOUT = 30;
    public final static long READ_TIMEOUT = 30;
    public final static long WRITE_TIMEOUT = 30;
    private final Object monitor = new Object();
    public static RetrofitFactory INSTANCE = null;
    private final OkHttpClient client;
    private HttpLoggingInterceptor loggingInterceptor;
    private UrlConverterApi urlConverterApi;

    private RetrofitFactory() {
        //初始化OkHttp
        loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        client = new OkHttpClient.Builder()
                .addInterceptor(loggingInterceptor)
                .connectTimeout(CONNECT_TIMEOUT, TimeUnit.SECONDS)
                .readTimeout(READ_TIMEOUT, TimeUnit.SECONDS)
                .writeTimeout(WRITE_TIMEOUT, TimeUnit.SECONDS)
                .build();
    }

    public static RetrofitFactory getInstance() {
        if (INSTANCE == null) {
            synchronized (RetrofitFactory.class) {
                if (INSTANCE == null) {
                    INSTANCE = new RetrofitFactory();
                }
            }
        }
        return INSTANCE;
    }

    public UrlConverterApi getUrlConverterApi() {
        if (urlConverterApi == null) {
            synchronized (monitor) {
                if (urlConverterApi == null) {
                    urlConverterApi = new Retrofit.Builder()
                            .baseUrl(getBaseUrl(UrlConverterApi.class))
                            .addConverterFactory(GsonConverterFactory.create())
                            .client(client)
                            .build()
                            .create(UrlConverterApi.class);
                }
            }
        }
        return urlConverterApi;
    }

    private <T> String getBaseUrl(Class<T> service) {
        if (service.getName() == UrlConverterApi.class.getName()) {
            return UrlConstant.getSearchResourceUrl();
        } else {
            return UrlConstant.getSearchResourceUrl();
        }
    }
}
