package com.xdja.servicebus.http.api;

import com.xdja.servicebus.http.entity.RequestUrlEntity;
import com.xdja.servicebus.http.entity.UrlEntity;

import java.util.List;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.POST;


/**
 * @author yuanwanli
 * @des 服务总线转换url
 * @date 2019/3/29
 */
public interface UrlConverterApi {
    /**
     * 利用服务总线后台转换url(同步)
     *
     * @param list 需要给后台传递的bean对象
     * @return
     */
    @POST("sod/api/rsb/v1/queryResourceAddress")
    Call<List<UrlEntity>> getUrls(@Header("appCredential") String appCredential, @Header("messageId") String messageId
            , @Header("version") String version, @Body List<RequestUrlEntity> list);
}
