package com.xdja.fwzxutils.bean;

import com.blankj.utilcode.util.TimeUtils;
import com.xdja.fwzxutils.base.BaseInfoUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yuanwanli
 * @des
 * @date 2020/1/14
 */
public class ResourceQueryBean {

    /**
     * messageId : d63873b6779042eebcbde0b8613e27b6
     * version : 1.0
     * parameter : {"dataObjId":"czrk","regionalismCode":"","networkCode":"","condition":{"logicalOperate":"and","keyValueList":[{"key":"name","relationOperator":"=","value":"'张三'"},{"key":"age","relationOperator":">","value":"20"}]},"fields":"name,age","orderBy":[{"orderbyField":"name","sort":"desc"},{"orderbyField":"age","sort":"asc"}],"page":{"pageSize":1,"pageNo":1}}
     */

    private String messageId;
    private String version = "1.0";
    private ParameterBean parameter;
    private List<String> heads= new ArrayList<>();

    public static ResourceQueryBean getQueryCommonBean(String queryXml, String dataObjId, String tag) {
        ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean keyValueListBean = new ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean();
        keyValueListBean.setKey(tag);
        keyValueListBean.setValue(queryXml);
        List<ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean> keyValueList = new ArrayList<>();
        keyValueList.add(keyValueListBean);
        ResourceQueryBean.ParameterBean.ConditionBean conditionBean = new ResourceQueryBean.ParameterBean.ConditionBean();
        conditionBean.setKeyValueList(keyValueList);
        ResourceQueryBean.ParameterBean parameterBean = new ResourceQueryBean.ParameterBean();
        parameterBean.setCondition(conditionBean);
        parameterBean.setDataObjId(dataObjId);
        parameterBean.setRegionalismCode(BaseInfoUtils.getOrgId());
        parameterBean.setNetworkCode(BaseInfoUtils.getNetworkAreaCode());
        ResourceQueryBean.ParameterBean.PageBean pageBean = new ResourceQueryBean.ParameterBean.PageBean();
        pageBean.setPageNo(1);
        pageBean.setPageSize(100000);
        parameterBean.setPage(pageBean);
        ResourceQueryBean bean = new ResourceQueryBean();
        bean.setParameter(parameterBean);
        bean.setMessageId("" + TimeUtils.getNowMills());
        return bean;
    }

    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ParameterBean getParameter() {
        return parameter;
    }

    public void setParameter(ParameterBean parameter) {
        this.parameter = parameter;
    }

    /**
     * 构建服务总线单参数请求参数
     *
     * @param key        键值
     * @param value      值
     * @param resourceId 服务总线资源id
     * @return
     */
    public static ResourceQueryBean getRequestBean(String key, String value, String resourceId) {
        ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean keyValueListBean = new ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean();
        keyValueListBean.setKey(key);
        keyValueListBean.setValue(value);
        List<ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean> keyValueList = new ArrayList<>();
        keyValueList.add(keyValueListBean);
        return getRequestBean(keyValueList, resourceId);
    }

    /**
     * 构建服务总线请求参数
     *
     * @param keyValueList 请求参数键值对
     * @param resourceId   服务总线资源id
     * @return
     */
    public static ResourceQueryBean getRequestBean(List<ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean> keyValueList, String resourceId) {
        ResourceQueryBean.ParameterBean.ConditionBean conditionBean = new ResourceQueryBean.ParameterBean.ConditionBean();
        conditionBean.setKeyValueList(keyValueList);
        ResourceQueryBean.ParameterBean parameterBean = new ResourceQueryBean.ParameterBean();
        parameterBean.setCondition(conditionBean);
        parameterBean.setDataObjId(resourceId);
        parameterBean.setRegionalismCode(BaseInfoUtils.getOrgId());
        parameterBean.setNetworkCode(BaseInfoUtils.getNetworkAreaCode());
        ResourceQueryBean.ParameterBean.PageBean pageBean = new ResourceQueryBean.ParameterBean.PageBean();
        pageBean.setPageNo(1);
        pageBean.setPageSize(100);
        parameterBean.setPage(pageBean);
        ResourceQueryBean bean = new ResourceQueryBean();
        bean.setParameter(parameterBean);
        bean.setMessageId("" + TimeUtils.getNowMills());
        return bean;
    }

    @Override
    public String toString() {
        return "ResourceQueryBean{" +
                "messageId='" + messageId + '\'' +
                ", version='" + version + '\'' +
                ", parameter=" + parameter +
                '}';
    }

    public List<String> getHeads() {
        return heads;
    }

    public void setHeads(List<String> heads) {
        this.heads = heads;
    }

    public static class ParameterBean {
        /**
         * dataObjId : czrk
         * regionalismCode :
         * networkCode :
         * condition : {"logicalOperate":"and","keyValueList":[{"key":"name","relationOperator":"=","value":"'张三'"},{"key":"age","relationOperator":">","value":"20"}]}
         * fields : name,age
         * orderBy : [{"orderbyField":"name","sort":"desc"},{"orderbyField":"age","sort":"asc"}]
         * page : {"pageSize":1,"pageNo":1}
         */

        private String dataObjId;
        private String regionalismCode;
        private String networkCode;
        private ConditionBean condition;
        private String fields = "*";
        private PageBean page;
        private List<OrderByBean> orderBy;

        public String getDataObjId() {
            return dataObjId;
        }

        public void setDataObjId(String dataObjId) {
            this.dataObjId = dataObjId;
        }

        public String getRegionalismCode() {
            return regionalismCode;
        }

        public void setRegionalismCode(String regionalismCode) {
            this.regionalismCode = regionalismCode;
        }

        public String getNetworkCode() {
            return networkCode;
        }

        public void setNetworkCode(String networkCode) {
            this.networkCode = networkCode;
        }

        public ConditionBean getCondition() {
            return condition;
        }

        public void setCondition(ConditionBean condition) {
            this.condition = condition;
        }

        public String getFields() {
            return fields;
        }

        public void setFields(String fields) {
            this.fields = fields;
        }

        public PageBean getPage() {
            return page;
        }

        public void setPage(PageBean page) {
            this.page = page;
        }

        public List<OrderByBean> getOrderBy() {
            return orderBy;
        }

        public void setOrderBy(List<OrderByBean> orderBy) {
            this.orderBy = orderBy;
        }

        @Override
        public String toString() {
            return "ParameterBean{" +
                    "dataObjId='" + dataObjId + '\'' +
                    ", regionalismCode='" + regionalismCode + '\'' +
                    ", networkCode='" + networkCode + '\'' +
                    ", condition=" + condition +
                    ", fields='" + fields + '\'' +
                    ", page=" + page +
                    ", orderBy=" + orderBy +
                    '}';
        }

        public static class ConditionBean {
            /**
             * logicalOperate : and
             * keyValueList : [{"key":"name","relationOperator":"=","value":"'张三'"},{"key":"age","relationOperator":">","value":"20"}]
             */

            private String logicalOperate = "and";
            private List<KeyValueListBean> keyValueList;

            public String getLogicalOperate() {
                return logicalOperate;
            }

            public void setLogicalOperate(String logicalOperate) {
                this.logicalOperate = logicalOperate;
            }

            public List<KeyValueListBean> getKeyValueList() {
                return keyValueList;
            }

            public void setKeyValueList(List<KeyValueListBean> keyValueList) {
                this.keyValueList = keyValueList;
            }

            @Override
            public String toString() {
                return "ConditionBean{" +
                        "logicalOperate='" + logicalOperate + '\'' +
                        ", keyValueList=" + keyValueList +
                        '}';
            }

            public static class KeyValueListBean {
                /**
                 * key : name
                 * relationOperator : =
                 * value : '张三'
                 */

                private String key = "req";
                private String relationOperator = "=";
                private String value;

                public String getKey() {
                    return key;
                }

                public void setKey(String key) {
                    this.key = key;
                }

                public String getRelationOperator() {
                    return relationOperator;
                }

                public void setRelationOperator(String relationOperator) {
                    this.relationOperator = relationOperator;
                }

                public String getValue() {
                    return value;
                }

                public void setValue(String value) {
                    this.value = value;
                }

                @Override
                public String toString() {
                    return "KeyValueListBean{" +
                            "key='" + key + '\'' +
                            ", relationOperator='" + relationOperator + '\'' +
                            ", value='" + value + '\'' +
                            '}';
                }
            }
        }

        public static class PageBean {
            /**
             * pageSize : 1
             * pageNo : 1
             */

            private int pageSize;
            private int pageNo;

            public int getPageSize() {
                return pageSize;
            }

            public void setPageSize(int pageSize) {
                this.pageSize = pageSize;
            }

            public int getPageNo() {
                return pageNo;
            }

            public void setPageNo(int pageNo) {
                this.pageNo = pageNo;
            }

            @Override
            public String toString() {
                return "PageBean{" +
                        "pageSize=" + pageSize +
                        ", pageNo=" + pageNo +
                        '}';
            }
        }

        public static class OrderByBean {
            /**
             * orderbyField : name
             * sort : desc
             */

            private String orderbyField;
            private String sort;

            public String getOrderbyField() {
                return orderbyField;
            }

            public void setOrderbyField(String orderbyField) {
                this.orderbyField = orderbyField;
            }

            public String getSort() {
                return sort;
            }

            public void setSort(String sort) {
                this.sort = sort;
            }

            @Override
            public String toString() {
                return "OrderByBean{" +
                        "orderbyField='" + orderbyField + '\'' +
                        ", sort='" + sort + '\'' +
                        '}';
            }
        }
    }
}
