package com.xdja.fwzxutils.exception;

import android.text.TextUtils;

public class ArmsException extends RuntimeException {
    private final String DEFAULT_CODE = this.getClass().getSimpleName() + "_DefaultCode";
    private String code;

    public ArmsException(String code) {
        this.code = this.DEFAULT_CODE;
        if (!TextUtils.isEmpty(code)) {
            this.code = code;
        }

    }

    public ArmsException(String code, String detailMessage) {
        super(detailMessage);
        this.code = this.DEFAULT_CODE;
        if (!TextUtils.isEmpty(code)) {
            this.code = code;
        }

    }

    public ArmsException(String code, String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        this.code = this.DEFAULT_CODE;
        if (!TextUtils.isEmpty(code)) {
            this.code = code;
        }

    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return "code : " + this.code + "\r\n" + super.toString();
    }
}
