package com.xdja.fwzxutils.transform;

import com.blankj.utilcode.util.TimeUtils;
import com.xdja.fwzxutils.bean.ResourceQueryBean;

import java.util.ArrayList;
import java.util.List;

import static com.xdja.fwzxutils.base.BaseInfoUtils.getNetworkAreaCode;
import static com.xdja.fwzxutils.base.BaseInfoUtils.getOrgId;

/**
 * @author yuanwanli
 * @des 服务总线请求bean转换器
 * @date 2020/1/14
 */
public class ResourceQueryBeanTransform {

    /**
     * 服务总线接口版本号
     */
    public static final String version = "1";
    /**
     * 获取实际json的标识
     */
    public static final String GPRS_SERVER_DATA = "res_xml";


    /**
     * 构建Gprs Server业务请求参数
     *
     * @param queryXml   请求报文
     * @param resourceId 服务总线资源id
     * @return
     */
    public static ResourceQueryBean getGprsServerRequest(String queryXml, String resourceId) {
        ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean keyValueListBean = new ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean();
        keyValueListBean.setValue(queryXml);
        List<ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean> keyValueList = new ArrayList<>();
        keyValueList.add(keyValueListBean);
        ResourceQueryBean.ParameterBean.ConditionBean conditionBean = new ResourceQueryBean.ParameterBean.ConditionBean();
        conditionBean.setKeyValueList(keyValueList);
        ResourceQueryBean.ParameterBean parameterBean = new ResourceQueryBean.ParameterBean();
        parameterBean.setCondition(conditionBean);
        parameterBean.setDataObjId(resourceId);
        parameterBean.setRegionalismCode(getOrgId());
        parameterBean.setNetworkCode(getNetworkAreaCode());
        ResourceQueryBean.ParameterBean.PageBean pageBean = new ResourceQueryBean.ParameterBean.PageBean();
        pageBean.setPageNo(1);
        pageBean.setPageSize(100000);
        parameterBean.setPage(pageBean);
        ResourceQueryBean bean = new ResourceQueryBean();
        bean.setParameter(parameterBean);
        bean.setMessageId("" + TimeUtils.getNowMills());
        return bean;
    }

    /**
     * 构建服务总线单参数请求参数
     *
     * @param key        键值
     * @param value      值
     * @param resourceId 服务总线资源id
     * @return
     */
    public static ResourceQueryBean getRequestBean(String key, String value, String resourceId) {
        ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean keyValueListBean = new ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean();
        keyValueListBean.setKey(key);
        keyValueListBean.setValue(value);
        List<ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean> keyValueList = new ArrayList<>();
        keyValueList.add(keyValueListBean);
        return getRequestBean(keyValueList, resourceId);
    }

    /**
     * 构建服务总线请求参数
     *
     * @param keyValueList 请求参数键值对
     * @param resourceId   服务总线资源id
     * @return
     */
    public static ResourceQueryBean getRequestBean(List<ResourceQueryBean.ParameterBean.ConditionBean.KeyValueListBean> keyValueList, String resourceId) {
        ResourceQueryBean.ParameterBean.ConditionBean conditionBean = new ResourceQueryBean.ParameterBean.ConditionBean();
        conditionBean.setKeyValueList(keyValueList);
        ResourceQueryBean.ParameterBean parameterBean = new ResourceQueryBean.ParameterBean();
        parameterBean.setCondition(conditionBean);
        parameterBean.setDataObjId(resourceId);
        parameterBean.setRegionalismCode(getOrgId());
        parameterBean.setNetworkCode(getNetworkAreaCode());
        ResourceQueryBean.ParameterBean.PageBean pageBean = new ResourceQueryBean.ParameterBean.PageBean();
        pageBean.setPageNo(1);
        pageBean.setPageSize(100);
        parameterBean.setPage(pageBean);
        ResourceQueryBean bean = new ResourceQueryBean();
        bean.setParameter(parameterBean);
        bean.setMessageId("" + TimeUtils.getNowMills());
        return bean;
    }
}
