/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.base;

import android.text.TextUtils;
import com.blankj.utilcode.util.CacheDoubleStaticUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.xdja.fwzxutils.base.DefaultFormatPrinter;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import com.xdja.fwzxutils.exception.ArmsException;
import com.xdja.fwzxutils.net.RetrofitFactory;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class BaseHttpRequest {
    private BaseHttpRequest() {
    }

    public static BaseHttpRequest getInstance() {
        return Holder.singleton;
    }

    public <ResponseType> Observable<List<ResponseType>> getListOfType(@NonNull ResourceQueryBean queryBean, @NonNull String tag, @NonNull Class<ResponseType> classOfT) {
        return this.getResponse(queryBean, tag).flatMap(response -> Observable.create(e -> {
            try {
                Type listType = GsonUtils.getListType((Type)classOfT);
                List powers = (List)GsonUtils.fromJson((String)response, (Type)listType);
                if (powers == null) {
                    e.onError(new Throwable("json\u89e3\u6790\u5b57\u6bb5\u5931\u8d25"));
                } else {
                    e.onNext((Object)powers);
                    e.onComplete();
                }
            }
            catch (Throwable throwable) {
                e.onError(throwable);
            }
        }));
    }

    public Observable<List<ResourceResponseBean.DataBean.DataListBean>> getResponse(@NonNull ResourceQueryBean queryBean) {
        return Observable.create(e -> {
            try {
                String resourceId = queryBean.getParameter().getDataObjId();
                String url = CacheDoubleStaticUtils.getString((String)resourceId);
                queryBean.getHeads().add("resourceId : " + resourceId);
                queryBean.getHeads().add("url : " + url);
                if (url == null || url.isEmpty()) {
                    String errorMessage = "\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a";
                    DefaultFormatPrinter.printRequest(queryBean, errorMessage, "");
                    e.onError(new Throwable("\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a"));
                    return;
                }
                ResourceResponseBean responseBean = (ResourceResponseBean)RetrofitFactory.getInstance().getServiceBusApi().getRequest(url, queryBean).execute().body();
                if (responseBean == null) {
                    String errorMessage = "\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,ResourceResponseBean\u4e3a\u7a7a";
                    DefaultFormatPrinter.printResponse(null, null, errorMessage, null);
                    e.onError(new Throwable(errorMessage));
                } else {
                    String messageId = responseBean.getMessageId();
                    ArrayList<String> heads = new ArrayList<String>();
                    heads.add("messageId : " + messageId);
                    if (responseBean.isSuccess().booleanValue()) {
                        DefaultFormatPrinter.printResponse(heads, GsonUtils.toJson(responseBean.getData().getDataList()), null, null);
                        e.onNext(responseBean.getData().getDataList());
                        e.onComplete();
                    } else {
                        String errorMessage = responseBean.getMessage();
                        DefaultFormatPrinter.printResponse(null, null, errorMessage, null);
                        e.onError((Throwable)new ArmsException(responseBean.getCode(), errorMessage));
                    }
                }
            }
            catch (Throwable throwable) {
                e.onError(throwable);
            }
        });
    }

    public Observable<String> getResponse(@NonNull ResourceQueryBean queryBean, @NonNull String tag) {
        return Observable.create(e -> {
            try {
                String resourceId = queryBean.getParameter().getDataObjId();
                if (TextUtils.isEmpty((CharSequence)resourceId)) {
                    String errorMessage = "resourceId\u4e3a\u7a7a";
                    DefaultFormatPrinter.printRequest(queryBean, errorMessage, tag);
                    e.onError(new Throwable(errorMessage));
                    return;
                }
                String url = CacheDoubleStaticUtils.getString((String)resourceId);
                queryBean.getHeads().add("messageId : " + queryBean.getMessageId());
                queryBean.getHeads().add("resourceId : " + resourceId);
                queryBean.getHeads().add("url : " + url);
                if (url == null || url.isEmpty()) {
                    String errorMessage = "\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a";
                    DefaultFormatPrinter.printRequest(queryBean, errorMessage, tag);
                    e.onError(new Throwable(errorMessage));
                    return;
                }
                DefaultFormatPrinter.printRequest(queryBean, null, tag);
                ResourceResponseBean responseBean = (ResourceResponseBean)RetrofitFactory.getInstance().getServiceBusApi().getRequest(url, queryBean).execute().body();
                if (responseBean == null) {
                    String errorMessage = "\u8054\u7f51\u8bf7\u6c42\u5931\u8d25,ResourceResponseBean\u4e3a\u7a7a";
                    DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                    e.onError(new Throwable(errorMessage));
                } else {
                    String messageId = responseBean.getMessageId();
                    ArrayList<String> heads = new ArrayList<String>();
                    heads.add("messageId : " + messageId);
                    if (responseBean.isSuccess().booleanValue()) {
                        List<ResourceResponseBean.DataBean.DataListBean> dataList = responseBean.getData().getDataList();
                        String response = null;
                        if (dataList != null && dataList.size() > 0) {
                            List<ResourceResponseBean.DataBean.DataListBean.FieldValuesBean> fieldValues = dataList.get(0).getFieldValues();
                            for (ResourceResponseBean.DataBean.DataListBean.FieldValuesBean bean : fieldValues) {
                                if (!tag.equals(bean.getField())) continue;
                                response = bean.getValue();
                                break;
                            }
                            if (response == null) {
                                String errorMessage = "\u89e3\u6790\u5b57\u6bb5\u5931\u8d25,\u7ea6\u5b9a\u8fd4\u56de\u4e3a\u7a7a";
                                DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                                e.onError(new Throwable(errorMessage));
                            } else {
                                DefaultFormatPrinter.printResponse(heads, response, null, tag);
                                e.onNext(response);
                                e.onComplete();
                            }
                        } else {
                            String errorMessage = "\u89e3\u6790\u5b57\u6bb5\u5931\u8d25,dataList\u5b57\u6bb5\u4e3a\u7a7a";
                            DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                            e.onError(new Throwable(errorMessage));
                        }
                    } else {
                        String errorMessage = responseBean.getMessage();
                        DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                        e.onError(new Throwable(errorMessage));
                    }
                }
            }
            catch (Throwable throwable) {
                e.onError(throwable);
            }
        });
    }

    private static class Holder {
        private static BaseHttpRequest singleton = new BaseHttpRequest();

        private Holder() {
        }
    }
}

