/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.base;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.CacheDoubleStaticUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.blankj.utilcode.util.Utils;
import com.xdja.fwzxutils.base.BaseInfoUtils;
import com.xdja.fwzxutils.base.DefaultFormatPrinter;
import com.xdja.fwzxutils.bean.CredentialBean;
import com.xdja.fwzxutils.bean.ResourceBean;
import com.xdja.fwzxutils.net.RetrofitFactory;
import com.xdja.uaac.api.UaacApi;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class BaseLoginUtils {
    public Observable<CredentialBean> getCredential() {
        return Observable.create(it -> {
            try {
                String messageId = String.valueOf(TimeUtils.getNowMills());
                String appId = BaseInfoUtils.getAppId();
                String orgId = BaseInfoUtils.getOrgId();
                String networkAreaCode = BaseInfoUtils.getNetworkAreaCode();
                String packageName = AppUtils.getAppPackageName();
                ArrayList<String> heads = new ArrayList<String>();
                heads.add("messageId : " + messageId);
                heads.add("appId : " + appId);
                heads.add("orgId : " + orgId);
                heads.add("networkAreaCode : " + networkAreaCode);
                heads.add("packageName : " + packageName);
                UaacApi.getCredential((Context)Utils.getApp(), (String)messageId, (String)"1", (String)appId, (String)orgId, (String)networkAreaCode, (String)packageName, bundle -> {
                    if (bundle == null) {
                        String errorMessage = "\u83b7\u53d6\u5e94\u7528\u51ed\u8bc1\u5931\u8d25,bundle\u4e3a\u7a7a";
                        DefaultFormatPrinter.printGetCredential(heads, null, null, errorMessage);
                        it.onError(new Throwable(errorMessage));
                    } else {
                        String messageIdBack = bundle.getString("messageId");
                        if (messageId.equals(messageIdBack)) {
                            String appCredential = bundle.getString("appCredential");
                            String userCredential = bundle.getString("userCredential");
                            if (!TextUtils.isEmpty((CharSequence)appCredential) && !TextUtils.isEmpty((CharSequence)userCredential)) {
                                CredentialBean credentialBean = new CredentialBean(appCredential, userCredential);
                                RetrofitFactory.appCredential = appCredential;
                                RetrofitFactory.userCredential = userCredential;
                                DefaultFormatPrinter.printGetCredential(heads, appCredential, userCredential, null);
                                it.onNext((Object)credentialBean);
                            } else {
                                String errorMessage = "\u83b7\u53d6\u5e94\u7528\u51ed\u8bc1\u5931\u8d25,\u5e94\u7528\u51ed\u8bc1\u8ddf\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a";
                                DefaultFormatPrinter.printGetCredential(heads, appCredential, userCredential, errorMessage);
                                it.onError(new Throwable(errorMessage));
                            }
                        } else {
                            String errorMessage = "\u83b7\u53d6\u5e94\u7528\u51ed\u8bc1\u5931\u8d25,messageId\u4e0d\u5bf9\u5e94";
                            DefaultFormatPrinter.printGetCredential(heads, null, null, errorMessage);
                            it.onError(new Throwable(errorMessage));
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                DefaultFormatPrinter.printGetCredential(new ArrayList<String>(), null, null, throwable.toString());
                it.onError(throwable);
            }
        });
    }

    public Observable<List<ResourceBean>> getResourceAddress(@NonNull String appCredential) {
        return Observable.create(it -> {
            try {
                Uri uri = Uri.parse((String)"content://com.ydjw.rsb.getResourceAddress");
                Bundle bundle = new Bundle();
                bundle.putString("appCredential", appCredential);
                bundle.putString("version", "1");
                String messageId = String.valueOf(TimeUtils.getNowMills());
                bundle.putString("messageId", messageId);
                ArrayList<String> heads = new ArrayList<String>();
                heads.add("messageId : " + messageId);
                heads.add("appCredential : " + appCredential);
                Bundle callBack = Utils.getApp().getContentResolver().call(uri, "", "", bundle);
                if (callBack == null) {
                    String errorMessage = "\u5bfb\u5740\u83b7\u53d6\u8d44\u6e90\u5217\u8868\u5931\u8d25,\u8fd4\u56debundle\u4e3a\u7a7a";
                    DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                    it.onError(new Throwable(errorMessage));
                } else {
                    String paramsMessageId = callBack.getString("messageId");
                    String resourceList = callBack.getString("resourceList");
                    if (messageId.equals(paramsMessageId)) {
                        int resultCode = callBack.getInt("resultCode");
                        if (resultCode == 0) {
                            if (!TextUtils.isEmpty((CharSequence)resourceList)) {
                                List list = (List)GsonUtils.fromJson((String)resourceList, (Type)GsonUtils.getListType(ResourceBean.class));
                                DefaultFormatPrinter.printGetResourceAddress(heads, resourceList, null);
                                if (list == null || list.size() == 0) {
                                    String errorMessage = "\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u5730\u5740\u5931\u8d25\uff0c\u8d44\u6e90\u5730\u5740\u4e3a\u7a7a";
                                    DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                                    it.onError(new Throwable(errorMessage));
                                } else {
                                    CacheDoubleStaticUtils.clear();
                                    for (int i = 0; i < list.size(); ++i) {
                                        ResourceBean resourceBean = (ResourceBean)list.get(i);
                                        CacheDoubleStaticUtils.put((String)resourceBean.getResourceId(), (String)resourceBean.getResourceAddress());
                                    }
                                }
                                it.onNext((Object)list);
                            } else {
                                String errorMessage = "\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u5730\u5740\u5931\u8d25\uff0c\u8d44\u6e90\u5730\u5740\u4e3a\u7a7a";
                                DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                                it.onError(new Throwable(errorMessage));
                            }
                        } else {
                            String errorMessage = "\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u5730\u5740\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0" + callBack.getString("message");
                            DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                            it.onError(new Throwable(errorMessage));
                        }
                    } else {
                        String errorMessage = "\u83b7\u53d6\u5e94\u7528\u8d44\u6e90\u5730\u5740\u5931\u8d25,messageId\u4e0d\u5bf9\u5e94";
                        DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                        it.onError(new Throwable(errorMessage));
                    }
                }
            }
            catch (Throwable throwable) {
                DefaultFormatPrinter.printGetResourceAddress(new ArrayList<String>(), null, throwable.toString());
                it.onError(throwable);
            }
        });
    }
}

