/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.utils;

import com.xdja.fwzxutils.base.BaseInfoUtils;
import com.xdja.fwzxutils.base.BaseLoginUtils;
import com.xdja.fwzxutils.bean.LoginBean;
import com.xdja.fwzxutils.bean.ResourceBean;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import com.xdja.fwzxutils.transform.GprsTransform;
import com.xdja.fwzxutils.transform.HttpTransform;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ServiceBusUtils {
    public static ServiceBusUtils getInstance() {
        return Holder.singleton;
    }

    public Observable<LoginBean> login() {
        BaseLoginUtils loginUtils = new BaseLoginUtils();
        return loginUtils.getCredential().concatMap(credentialBean -> loginUtils.getResourceAddress(credentialBean.getAppCredential()).map(resourceBeans -> {
            LoginBean loginBean = new LoginBean();
            loginBean.setAppCredential(credentialBean.getAppCredential());
            loginBean.setUserCredential(credentialBean.getUserCredential());
            loginBean.setResourceBeanList((List<ResourceBean>)resourceBeans);
            return loginBean;
        })).subscribeOn(Schedulers.io());
    }

    public Observable<LoginResponse> getGprsLogin(LoginRequest loginRequest) {
        GprsTransform gprsTransform = new GprsTransform();
        return this.login().concatMap(loginBean -> gprsTransform.getPoliceInfo(loginRequest, loginBean.getUserInfo().getSfzh())).timeout(60L, TimeUnit.SECONDS).subscribeOn(Schedulers.io());
    }

    public <RequestType, ResponseType> Observable<ResponseType> getGprsBusiness(@NonNull RequestType requestType, @NonNull Class<ResponseType> classOfT) {
        GprsTransform gprsTransform = new GprsTransform();
        return gprsTransform.getGprsRequest(BaseInfoUtils.getGprsBusinessResId(), requestType, classOfT).subscribeOn(Schedulers.io());
    }

    public <ResponseType> Observable<ResponseType> getJsonRequest(@NonNull String resourceId, @NonNull Object jsonObject, @NonNull Class<ResponseType> classOfT) {
        HttpTransform httpTransform = new HttpTransform();
        return httpTransform.getJsonRequest(resourceId, jsonObject, classOfT).subscribeOn(Schedulers.io());
    }

    public <ResponseType> Observable<ResponseType> getJsonRequestWithTag(@NonNull String resourceId, @NonNull String requestTag, @NonNull String responseTag, @NonNull Object jsonObject, @NonNull Class<ResponseType> classOfT) {
        HttpTransform httpTransform = new HttpTransform();
        return httpTransform.getJsonRequestWithTag(resourceId, requestTag, responseTag, jsonObject, classOfT).subscribeOn(Schedulers.io());
    }

    public Observable<List<ResourceResponseBean.DataBean.DataListBean>> requestThirdApi(ResourceQueryBean resourceQueryBean) {
        HttpTransform httpTransform = new HttpTransform();
        return httpTransform.requestThirdApi(resourceQueryBean).subscribeOn(Schedulers.io());
    }

    private static class Holder {
        private static ServiceBusUtils singleton = new ServiceBusUtils();

        private Holder() {
        }
    }
}

