package com.xdja.fwzxutils.base;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;

import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.CacheDoubleStaticUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.blankj.utilcode.util.Utils;
import com.xdja.fwzxutils.bean.CredentialBean;
import com.xdja.fwzxutils.bean.ResourceBean;
import com.xdja.fwzxutils.net.RetrofitFactory;
import com.xdja.uaac.api.UaacApi;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;

/**
 * @author yuanwanli
 * @des 服务总线登录相关工具
 * @date 2020/9/22
 */
public class BaseLoginUtils {
    /**
     * 获取该app需要的用户凭证跟应用凭证
     *
     * @return CredentialBean
     */
    public Observable<CredentialBean> getCredential() {
        return Observable.create(it -> {
                    try {
                        String messageId = String.valueOf(TimeUtils.getNowMills());
                        String appId = BaseInfoUtils.getAppId();
                        String orgId = BaseInfoUtils.getOrgId();
                        String networkAreaCode = BaseInfoUtils.getNetworkAreaCode();
                        String packageName = AppUtils.getAppPackageName();
                        List<String> heads = new ArrayList<>();
                        heads.add("messageId : " + messageId);
                        heads.add("appId : " + appId);
                        heads.add("orgId : " + orgId);
                        heads.add("networkAreaCode : " + networkAreaCode);
                        heads.add("packageName : " + packageName);
                        UaacApi.getCredential(Utils.getApp(), messageId, "1", appId, orgId, networkAreaCode, packageName,
                                bundle -> {
                                    if (bundle == null) {
                                        String errorMessage = "获取应用凭证失败,bundle为空";
                                        DefaultFormatPrinter.printGetCredential(heads, null, null, errorMessage);
                                        it.onError(new Throwable(errorMessage));
                                    } else {
                                        String messageIdBack = bundle.getString("messageId");
                                        if (messageId.equals(messageIdBack)) {
                                            String appCredential = bundle.getString("appCredential");
                                            String userCredential = bundle.getString("userCredential");
                                            if (!TextUtils.isEmpty(appCredential) && !TextUtils.isEmpty(userCredential)) {
                                                CredentialBean credentialBean = new CredentialBean(appCredential, userCredential);
                                                RetrofitFactory.appCredential = appCredential;
                                                RetrofitFactory.userCredential = userCredential;
                                                DefaultFormatPrinter.printGetCredential(heads, appCredential, userCredential, null);
                                                it.onNext(credentialBean);
                                            } else {
                                                String errorMessage = "获取应用凭证失败,应用凭证跟用户凭证为空";
                                                DefaultFormatPrinter.printGetCredential(heads, appCredential, userCredential, errorMessage);
                                                it.onError(new Throwable(errorMessage));
                                            }
                                        } else {
                                            String errorMessage = "获取应用凭证失败,messageId不对应";
                                            DefaultFormatPrinter.printGetCredential(heads, null, null, errorMessage);
                                            it.onError(new Throwable(errorMessage));
                                        }
                                    }
                                });
                    } catch (Throwable throwable) {
                        DefaultFormatPrinter.printGetCredential(new ArrayList<>(), null, null, throwable.toString());
                        it.onError(throwable);
                    }
                }
        );
    }

    /**
     * 获取该app注册的所有接口资源
     *
     * @param appCredential 应用凭证
     * @return List<ResourceBean>
     */
    public Observable<List<ResourceBean>> getResourceAddress(@NonNull String appCredential) {
        //获取应用虚拟接口地址
        return Observable.create(it -> {
            try {
                Uri uri = Uri.parse("content://com.ydjw.rsb.getResourceAddress");
                Bundle bundle = new Bundle();
                bundle.putString("appCredential", appCredential);
                bundle.putString("version", "1");
                String messageId = String.valueOf(TimeUtils.getNowMills());
                bundle.putString("messageId", messageId);
                List<String> heads = new ArrayList<>();
                heads.add("messageId : " + messageId);
                heads.add("appCredential : " + appCredential);
                Bundle callBack = Utils.getApp().getContentResolver().call(uri, "", "", bundle);
                if (callBack == null) {
                    String errorMessage = "寻址获取资源列表失败,返回bundle为空";
                    DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                    it.onError(new Throwable(errorMessage));
                } else {
                    String paramsMessageId = callBack.getString("messageId");
                    String resourceList = callBack.getString("resourceList");
                    if (messageId.equals(paramsMessageId)) {
                        int resultCode = callBack.getInt("resultCode");
                        if (resultCode == 0) {
                            if (!TextUtils.isEmpty(resourceList)) {
                                List<ResourceBean> list = GsonUtils.fromJson(resourceList, GsonUtils.getListType(ResourceBean.class));
                                DefaultFormatPrinter.printGetResourceAddress(heads, resourceList, null);
                                if (list == null || list.size() == 0) {
                                    String errorMessage = "获取应用资源地址失败，资源地址为空";
                                    DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                                    it.onError(new Throwable(errorMessage));
                                } else {
                                    CacheDoubleStaticUtils.clear();
                                    for (int i = 0; i < list.size(); i++) {
                                        ResourceBean resourceBean = list.get(i);
                                        CacheDoubleStaticUtils.put(resourceBean.getResourceId(), resourceBean.getResourceAddress());
                                    }
                                }
                                it.onNext(list);
                            } else {
                                String errorMessage = "获取应用资源地址失败，资源地址为空";
                                DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                                it.onError(new Throwable(errorMessage));
                            }
                        } else {
                            String errorMessage = "获取应用资源地址失败，失败原因" + callBack.getString("message");
                            DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                            it.onError(new Throwable(errorMessage));
                        }
                    } else {
                        String errorMessage = "获取应用资源地址失败,messageId不对应";
                        DefaultFormatPrinter.printGetResourceAddress(heads, null, errorMessage);
                        it.onError(new Throwable(errorMessage));
                    }
                }
            } catch (Throwable throwable) {
                DefaultFormatPrinter.printGetResourceAddress(new ArrayList<>(), null, throwable.toString());
                it.onError(throwable);
            }
        });
    }
}











