package com.xdja.fwzxutils.transform;

import com.blankj.utilcode.util.GsonUtils;
import com.xdja.fwzxutils.base.BaseHttpRequest;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import com.xdja.fwzxutils.common.Constant;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;

/**
 * @author yuanwanli
 * @des http接口对接服务总线转换类
 * @date 2020/9/22
 */
public class HttpTransform {

    /**
     * 获取协议是json的数据
     *
     * @param resourceId     接口id
     * @param jsonObject     json对象,传bean
     * @param classOfT       返回bean的class
     * @param <ResponseType> 返回bean类型
     * @return json解析实体类
     */
    public <ResponseType> Observable<ResponseType> getJsonRequest(@NonNull String resourceId, @NonNull Object jsonObject, @NonNull Class<ResponseType> classOfT) {
        String json = GsonUtils.toJson(jsonObject);
        ResourceQueryBean queryBean = ResourceQueryBean.getQueryCommonBean(json, resourceId, Constant.JSON_REQ);
        return BaseHttpRequest.getInstance().getResponse(queryBean, Constant.JSON_DATA)
                .flatMap((Function<String, ObservableSource<ResponseType>>) response ->
                        Observable.create((ObservableOnSubscribe<ResponseType>) emitter -> {
                            try {
                                // 解析返回结果
                                ResponseType responseType = GsonUtils.fromJson(response, classOfT);
                                if (responseType == null) {
                                    emitter.onError(new Throwable("json解析字段失败"));
                                } else {
                                    emitter.onNext(responseType);
                                    emitter.onComplete();
                                }
                            } catch (Throwable throwable) {
                                emitter.onError(throwable);
                            }
                        }));
    }

    /**
     * 获取协议是json的数据
     *
     * @param resourceId     接口id
     * @param requestTag     前后台约定的入参标识
     * @param responseTag    前后台约定的出参标识
     * @param jsonObject     json对象,传bean
     * @param classOfT       返回bean的class
     * @param <ResponseType> 返回bean类型
     * @return json解析实体类
     */
    public <ResponseType> Observable<ResponseType> getJsonRequestWithTag(@NonNull String resourceId, @NonNull String requestTag, @NonNull String responseTag, @NonNull Object jsonObject, @NonNull Class<ResponseType> classOfT) {
        String json = GsonUtils.toJson(jsonObject);
        ResourceQueryBean queryBean = ResourceQueryBean.getQueryCommonBean(json, resourceId, requestTag);
        return BaseHttpRequest.getInstance().getResponse(queryBean, responseTag)
                .flatMap((Function<String, ObservableSource<ResponseType>>) response ->
                        Observable.create((ObservableOnSubscribe<ResponseType>) emitter -> {
                            try {
                                // 解析返回结果
                                ResponseType responseType = GsonUtils.fromJson(response, classOfT);
                                if (responseType == null) {
                                    emitter.onError(new Throwable("json解析字段失败"));
                                } else {
                                    emitter.onNext(responseType);
                                    emitter.onComplete();
                                }
                            } catch (Throwable throwable) {
                                emitter.onError(throwable);
                            }
                        }));
    }

    public Observable<List<ResourceResponseBean.DataBean.DataListBean>> requestThirdApi(@NonNull ResourceQueryBean queryBean) {
        return BaseHttpRequest.getInstance().getResponse(queryBean);
    }
}











