/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.base;

import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.ThreadUtils;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.utils.CharacterUtils;
import com.xdja.fwzxutils.utils.MyTask;
import java.util.Collections;
import java.util.List;

public class DefaultFormatPrinter {
    private static final String Get_Credential_Head = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 \u83b7\u53d6\u51ed\u8bc1 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510";
    private static final String Get_ResourceAddress_Head = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 \u5bfb\u5740 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510";
    private static final String Get_GPRS_Request_Head = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 GPRServer \u8bf7\u6c42 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510";
    private static final String Get_Request_Head = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 \u670d\u52a1\u603b\u7ebf\u8bf7\u6c42 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510";
    private static final String Get_GPRS_Response_Head = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 GPRServer \u8fd4\u56de \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510";
    private static final String Get_Response_Head = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500 \u670d\u52a1\u603b\u7ebf\u8fd4\u56de \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510";
    private static final String Base_Foot = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518";
    private static final String MainRequestTag = "\u251c \u91cd\u8981\u5165\u53c2(messageId\u5bf9\u5e94\u8fd4\u56de\u7684messageId)";
    private static final String MainResponseTag = "\u251c \u91cd\u8981\u51fa\u53c2";
    private static final String AllGprServerRequestTag = "\u251c gprs\u5b8c\u6574\u5165\u53c2 ";
    private static final String AllGprServerResponseTag = "\u251c gprs\u5b8c\u6574\u51fa\u53c2 ";
    private static final String AllRequestTag = "\u251c \u5b8c\u6574\u5165\u53c2 ";
    private static final String AllResponseTag = "\u251c \u5b8c\u6574\u51fa\u53c2 ";
    private static final String RequestTag = "\u251c \u5165\u53c2 ";
    private static final String ResponseTag = "\u251c \u51fa\u53c2 ";
    private static final String CORNER_UP = "\u250c ";
    private static final String CORNER_BOTTOM = "\u2514 ";
    private static final String CENTER_LINE = "\u251c ";
    private static final String DEFAULT_LINE = "\u2502 ";

    public static void printGetCredential(List<String> request, String appCredential, String userCredential, String errorMessage) {
        Log.d((String)"servicebus", (String)Get_Credential_Head);
        Log.d((String)"servicebus", (String)RequestTag);
        DefaultFormatPrinter.logLines(request);
        Log.d((String)"servicebus", (String)ResponseTag);
        if (!TextUtils.isEmpty((CharSequence)appCredential)) {
            Log.d((String)"servicebus", (String)("\u2502 appCredential : " + CharacterUtils.jsonFormat(appCredential)));
        }
        if (!TextUtils.isEmpty((CharSequence)userCredential)) {
            Log.d((String)"servicebus", (String)("\u2502 userCredential : " + CharacterUtils.jsonFormat(userCredential)));
        }
        if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
            Log.d((String)"servicebus", (String)("\u2502 \u9519\u8bef\u4fe1\u606f : " + errorMessage));
        }
        Log.d((String)"servicebus", (String)Base_Foot);
    }

    public static void printGetResourceAddress(List<String> request, String response, String errorMessage) {
        Log.d((String)"servicebus", (String)Get_ResourceAddress_Head);
        Log.d((String)"servicebus", (String)RequestTag);
        DefaultFormatPrinter.logLines(request);
        Log.d((String)"servicebus", (String)ResponseTag);
        if (!TextUtils.isEmpty((CharSequence)response)) {
            Log.d((String)"servicebus", (String)(DEFAULT_LINE + CharacterUtils.jsonFormat(response)));
        }
        if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
            Log.d((String)"servicebus", (String)("\u2502 \u9519\u8bef\u4fe1\u606f : " + errorMessage));
        }
        Log.d((String)"servicebus", (String)Base_Foot);
    }

    public static void printRequest(final ResourceQueryBean queryBean, final String errorMessage, final String tag) {
        MyTask myTask = new MyTask(){

            @Override
            public String doInBackground() throws Throwable {
                List<String> heads = queryBean.getHeads();
                Collections.reverse(heads);
                if ("res_xml".equals(tag)) {
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.Get_GPRS_Request_Head);
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.MainRequestTag);
                    DefaultFormatPrinter.logLines(heads);
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.AllGprServerRequestTag);
                    String xmlValue = queryBean.getParameter().getCondition().getKeyValueList().get(0).getValue();
                    DefaultFormatPrinter.logLine(CharacterUtils.xmlFormat(xmlValue));
                } else {
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.Get_Request_Head);
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.MainRequestTag);
                    DefaultFormatPrinter.logLines(heads);
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.AllRequestTag);
                    DefaultFormatPrinter.logLine(CharacterUtils.jsonFormat(GsonUtils.toJson((Object)queryBean)));
                }
                if (errorMessage != null) {
                    Log.d((String)"servicebus", (String)("\u2502 \u8bf7\u6c42\u51fa\u9519 : " + errorMessage));
                }
                Log.d((String)"servicebus", (String)DefaultFormatPrinter.Base_Foot);
                return super.doInBackground();
            }
        };
        ThreadUtils.executeBySingle((ThreadUtils.Task)myTask);
    }

    public static void printResponse(final List<String> heads, final String response, final String errorMessage, final String tag) {
        MyTask myTask = new MyTask(){

            @Override
            public String doInBackground() throws Throwable {
                if ("res_xml".equals(tag)) {
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.Get_GPRS_Response_Head);
                    if (heads != null) {
                        Log.d((String)"servicebus", (String)DefaultFormatPrinter.MainResponseTag);
                        DefaultFormatPrinter.logLines(heads);
                    }
                    if (errorMessage != null) {
                        Log.d((String)"servicebus", (String)("\u2502 \u8bf7\u6c42\u51fa\u9519 : " + errorMessage));
                    }
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.AllGprServerResponseTag);
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        DefaultFormatPrinter.logLine(CharacterUtils.xmlFormat(response));
                    } else {
                        Log.d((String)"servicebus", (String)"\u2502 \u65e0");
                    }
                } else {
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.Get_Response_Head);
                    if (heads != null) {
                        Log.d((String)"servicebus", (String)DefaultFormatPrinter.MainResponseTag);
                        DefaultFormatPrinter.logLines(heads);
                    }
                    if (errorMessage != null) {
                        Log.d((String)"servicebus", (String)("\u2502 \u8bf7\u6c42\u51fa\u9519 : " + errorMessage));
                    }
                    Log.d((String)"servicebus", (String)DefaultFormatPrinter.AllResponseTag);
                    if (!TextUtils.isEmpty((CharSequence)response)) {
                        DefaultFormatPrinter.logLine(CharacterUtils.jsonFormat(response));
                    } else {
                        Log.d((String)"servicebus", (String)"\u2502 \u65e0");
                    }
                }
                Log.d((String)"servicebus", (String)DefaultFormatPrinter.Base_Foot);
                return super.doInBackground();
            }
        };
        ThreadUtils.executeBySingle((ThreadUtils.Task)myTask);
    }

    private static void logLines(List<String> lines) {
        for (String line : lines) {
            int lineLength = line.length();
            int maxLongSize = 110;
            for (int i = 0; i <= lineLength / maxLongSize; ++i) {
                int start = i * maxLongSize;
                int end = (i + 1) * maxLongSize;
                end = Math.min(end, line.length());
                Log.d((String)"servicebus", (String)(DEFAULT_LINE + line.substring(start, end)));
            }
        }
    }

    private static void logLine(String line) {
        int lineLength = line.length();
        int maxLongSize = 4000;
        for (int i = 0; i <= lineLength / maxLongSize; ++i) {
            int start = i * maxLongSize;
            int end = (i + 1) * maxLongSize;
            end = Math.min(end, line.length());
            Log.d((String)"servicebus", (String)(DEFAULT_LINE + line.substring(start, end)));
        }
    }
}

