/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.transform;

import android.text.TextUtils;
import com.xdja.fwzxutils.base.BaseHttpRequest;
import com.xdja.fwzxutils.base.BaseInfoUtils;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.exception.ArmsException;
import com.xdja.fwzxutils.exception.TimeoutException;
import com.xdja.fwzxutils.utils.CErrorInfo;
import com.xdja.gprsconverter.convert.ConvertFactory;
import com.xdja.gprsconverter.protocol.ChangePwdRequest;
import com.xdja.gprsconverter.protocol.EntryRequest;
import com.xdja.gprsconverter.protocol.GetDataSourceRequest;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import com.xdja.gprsconverter.protocol.LogoutRequest;
import com.xdja.gprsconverter.protocol.QueryRequest;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class GprsTransform {
    private Observable<List<String>> getPowerFromServiceBus(String idCard, String powerId) {
        ResourceQueryBean queryBean = ResourceQueryBean.getQueryCommonBean(idCard, powerId, "req_xml");
        return BaseHttpRequest.getInstance().getListOfType(queryBean, "res_xml", String.class).onErrorReturnItem(new ArrayList());
    }

    public Observable<LoginResponse> getPoliceInfo(@NonNull LoginRequest loginRequest, String idCard) {
        String gprsLoginResId = BaseInfoUtils.getGprsLoginResId();
        String powerId = BaseInfoUtils.getGprsPowerId();
        Observable<LoginResponse> loginResponseObservable = this.getGprsRequest(gprsLoginResId, loginRequest, LoginResponse.class, false);
        if (!TextUtils.isEmpty((CharSequence)powerId)) {
            Observable<List<String>> powerFromServiceBus = this.getPowerFromServiceBus(idCard, powerId);
            return Observable.zip(loginResponseObservable, powerFromServiceBus, (loginResponse, powers) -> {
                StringBuilder stringBuilder = new StringBuilder();
                for (String power : powers) {
                    stringBuilder.append(power).append("#");
                }
                loginResponse.setPower(stringBuilder.toString());
                return loginResponse;
            });
        }
        return loginResponseObservable;
    }

    public <RequestType, ResponseType> Observable<ResponseType> getGprsRequest(@NonNull String resourceId, @NonNull RequestType requestType, @NonNull Class<ResponseType> classOfT, boolean getPhoto) {
        return Observable.create(emitter -> {
            String xml = "";
            xml = BaseInfoUtils.controlId != null && BaseInfoUtils.controlName != null ? this.generateXML(requestType) : ConvertFactory.generateXML((Object)requestType);
            String reqType = this.getReqType(xml);
            ResourceQueryBean queryBean = ResourceQueryBean.getQueryCommonBean(xml, resourceId, "req_xml");
            ArrayList<String> heads = new ArrayList<String>();
            heads.add("controlId : " + BaseInfoUtils.controlId);
            heads.add("controlName : " + BaseInfoUtils.controlName);
            heads.add("reqType : " + reqType);
            heads.add("messageId : " + queryBean.getMessageId());
            queryBean.setHeads(heads);
            emitter.onNext((Object)queryBean);
            emitter.onComplete();
        }).flatMap(queryBean -> BaseHttpRequest.getInstance().getResponse((ResourceQueryBean)queryBean, "res_xml")).flatMap(response -> Observable.create(emitter -> {
            try {
                CErrorInfo.parseErrorMsg(response);
                if (CErrorInfo.isError && !CErrorInfo.message.contains("\u4fee\u6539\u5bc6\u7801\u6210\u529f")) {
                    if (response == null || !response.startsWith("0x00000000")) {
                        ArmsException throwable = new ArmsException(CErrorInfo.code, CErrorInfo.message);
                        emitter.onError((Throwable)throwable);
                        return;
                    }
                    Object responseType = classOfT.newInstance();
                    emitter.onNext(responseType);
                    emitter.onComplete();
                    if ("0x13014034".equals(CErrorInfo.code) || CErrorInfo.message.contains("\u767b\u9646\u8d85\u65f6")) {
                        emitter.onError((Throwable)new TimeoutException());
                    }
                } else {
                    if (response.contains("00 \u672a\u627e\u5230\u8bb0\u5f55")) {
                        Object responseType = classOfT.newInstance();
                        emitter.onNext(responseType);
                    } else {
                        emitter.onNext(ConvertFactory.parserResponse((String)response, (Class)classOfT, (boolean)getPhoto));
                    }
                    emitter.onComplete();
                }
            }
            catch (Throwable throwable) {
                emitter.onError(throwable);
            }
        }));
    }

    private String getReqType(String reqStr) {
        String reqType = "";
        try {
            XmlPullParser xmlPullParser = XmlPullParserFactory.newInstance().newPullParser();
            xmlPullParser.setInput((Reader)new StringReader(reqStr));
            int eventType = xmlPullParser.getEventType();
            while (eventType != 1) {
                String name;
                if (eventType == 2 && (name = xmlPullParser.getName()).equals("ReqType")) {
                    reqType = xmlPullParser.nextText();
                    break;
                }
                eventType = xmlPullParser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reqType;
    }

    private <T> String generateXML(T t) {
        if (t instanceof QueryRequest) {
            ((QueryRequest)t).setAppKey(BaseInfoUtils.controlId);
            ((QueryRequest)t).setReqDigest(BaseInfoUtils.controlName);
            return ConvertFactory.generateQueryXML((QueryRequest)((QueryRequest)t));
        }
        if (t instanceof EntryRequest) {
            ((EntryRequest)t).setAppKey(BaseInfoUtils.controlId);
            ((EntryRequest)t).setReqDigest(BaseInfoUtils.controlName);
            return ConvertFactory.generateEntryXML((EntryRequest)((EntryRequest)t));
        }
        if (t instanceof LoginRequest) {
            ((LoginRequest)t).setAppKey(BaseInfoUtils.controlId);
            ((LoginRequest)t).setReqDigest(BaseInfoUtils.controlName);
            return ConvertFactory.generateLoginXML((LoginRequest)((LoginRequest)t));
        }
        if (t instanceof LogoutRequest) {
            ((LogoutRequest)t).setAppKey(BaseInfoUtils.controlId);
            ((LogoutRequest)t).setReqDigest(BaseInfoUtils.controlName);
            return ConvertFactory.generateLogoutXML((LogoutRequest)((LogoutRequest)t));
        }
        if (t instanceof ChangePwdRequest) {
            ((ChangePwdRequest)t).setAppKey(BaseInfoUtils.controlId);
            ((ChangePwdRequest)t).setReqDigest(BaseInfoUtils.controlName);
            return ConvertFactory.generateChangePwdXML((ChangePwdRequest)((ChangePwdRequest)t));
        }
        if (t instanceof GetDataSourceRequest) {
            ((GetDataSourceRequest)t).setAppKey(BaseInfoUtils.controlId);
            ((GetDataSourceRequest)t).setReqDigest(BaseInfoUtils.controlName);
            return ConvertFactory.generateGetDataSourceXML((GetDataSourceRequest)((GetDataSourceRequest)t));
        }
        if (t instanceof String) {
            return (String)t;
        }
        return null;
    }
}

