/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.transform;

import com.blankj.utilcode.util.GsonUtils;
import com.xdja.fwzxutils.base.BaseHttpRequest;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import java.util.List;

public class HttpTransform {
    public <ResponseType> Observable<ResponseType> getJsonRequest(@NonNull String resourceId, @NonNull Object jsonObject, @NonNull Class<ResponseType> classOfT) {
        String json = GsonUtils.toJson((Object)jsonObject);
        ResourceQueryBean queryBean = ResourceQueryBean.getQueryCommonBean(json, resourceId, "req_json");
        return BaseHttpRequest.getInstance().getResponse(queryBean, "res_json").flatMap(response -> Observable.create(emitter -> {
            try {
                Object responseType = GsonUtils.fromJson((String)response, (Class)classOfT);
                if (responseType == null) {
                    emitter.onError(new Throwable("json\u89e3\u6790\u5b57\u6bb5\u5931\u8d25"));
                } else {
                    emitter.onNext(responseType);
                    emitter.onComplete();
                }
            }
            catch (Throwable throwable) {
                emitter.onError(throwable);
            }
        }));
    }

    public <ResponseType> Observable<ResponseType> getJsonRequestWithTag(@NonNull String resourceId, @NonNull String requestTag, @NonNull String responseTag, @NonNull Object jsonObject, @NonNull Class<ResponseType> classOfT) {
        String json = GsonUtils.toJson((Object)jsonObject);
        ResourceQueryBean queryBean = ResourceQueryBean.getQueryCommonBean(json, resourceId, requestTag);
        return BaseHttpRequest.getInstance().getResponse(queryBean, responseTag).flatMap(response -> Observable.create(emitter -> {
            try {
                Object responseType = GsonUtils.fromJson((String)response, (Class)classOfT);
                if (responseType == null) {
                    emitter.onError(new Throwable("json\u89e3\u6790\u5b57\u6bb5\u5931\u8d25"));
                } else {
                    emitter.onNext(responseType);
                    emitter.onComplete();
                }
            }
            catch (Throwable throwable) {
                emitter.onError(throwable);
            }
        }));
    }

    public Observable<List<ResourceResponseBean.DataBean.DataListBean>> requestThirdApi(@NonNull ResourceQueryBean queryBean) {
        return BaseHttpRequest.getInstance().getResponse(queryBean);
    }
}

