/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.fwzxutils.utils;

import android.text.TextUtils;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CharacterUtils {
    private CharacterUtils() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static String jsonFormat(String json) {
        String message;
        if (TextUtils.isEmpty((CharSequence)json)) {
            return "Empty/Null json content";
        }
        try {
            json = json.trim();
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                message = jsonObject.toString(4);
            } else if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                message = jsonArray.toString(4);
            } else {
                message = json;
            }
        }
        catch (JSONException e) {
            message = json;
        }
        catch (OutOfMemoryError error) {
            message = "Output omitted because of Object size";
        }
        return message;
    }

    public static String xmlFormat(String xml) {
        String message;
        if (TextUtils.isEmpty((CharSequence)xml)) {
            return "Empty/Null xml content";
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            message = xmlOutput.getWriter().toString().replaceFirst(">", ">\n");
        }
        catch (TransformerException e) {
            message = xml;
        }
        return message;
    }
}

