package com.xdja.fwzxutils.base;

import android.text.TextUtils;

import com.blankj.utilcode.util.CacheDoubleStaticUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.xdja.fwzxutils.bean.ResourceQueryBean;
import com.xdja.fwzxutils.bean.ResourceResponseBean;
import com.xdja.fwzxutils.exception.CustomThrowable;
import com.xdja.fwzxutils.exception.TimeoutException;
import com.xdja.fwzxutils.net.RetrofitFactory;
import com.xdja.fwzxutils.utils.ErrorCallBack;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableSource;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;

/**
 * @author yuanwanli
 * @des
 * @date 2020/9/22
 */
public class BaseHttpRequest extends BaseRequest{
    private BaseHttpRequest() {
    }

    /**
     * 静态内部类实现单例
     *
     * @return ServiceBusLoginUtils
     */
    public static BaseHttpRequest getInstance() {
        return BaseHttpRequest.Holder.singleton;
    }

    /**
     * 请求集合数据
     *
     * @param queryBean      请求bean
     * @param tag            终端后台定义用来解析的标识
     * @param classOfT       数据类型class
     * @param <ResponseType> 数据bean
     * @return List<Bean>
     */
    public <ResponseType> Observable<List<ResponseType>> getListOfType(@NonNull ResourceQueryBean queryBean, @NonNull String tag, @NonNull Class<ResponseType> classOfT) {
        return getResponse(queryBean, tag)
                .flatMap((Function<String, ObservableSource<List<ResponseType>>>) response -> Observable.create(e -> {
                    try {
                        Type listType = GsonUtils.getListType(classOfT);
                        List<ResponseType> powers = GsonUtils.fromJson(response, listType);
                        if (powers == null) {
                            e.onError(new Throwable("json解析字段失败"));
                        } else {
                            e.onNext(powers);
                            e.onComplete();
                        }
                    } catch (Throwable throwable) {
                        e.onError(throwable);
                    }
                }));
    }

    /**
     * @param queryBean 请求bean
     * @return 终端根据需要自行解析服务总线返回数据
     */
    public Observable<List<ResourceResponseBean.DataBean.DataListBean>> getResponse(@NonNull ResourceQueryBean queryBean) {
        return Observable.create(e -> {
            try {
                ResourceResponseBean responseBean = super.getResponse(e, queryBean, null);
                if (responseBean != null) {
                    String messageId = responseBean.getMessageId();
                    List<String> heads = new ArrayList<>();
                    heads.add("messageId : " + messageId);
                    if (responseBean.isSuccess()) {
                        DefaultFormatPrinter.printResponse(heads, GsonUtils.toJson(responseBean.getData().getDataList()), null, null);
                        e.onNext(responseBean.getData().getDataList());
                        e.onComplete();
                    } else {
                        dealErrorInfo(e, responseBean,null);
                    }
                }
            } catch (Throwable throwable) {
                e.onError(throwable);
            }
        });
    }

    /**
     * @param queryBean 请求bean
     * @param tag       前后台标识
     * @return 终端实际需要的String字符串(可为json或者xml)
     */
    public Observable<String> getResponse(@NonNull ResourceQueryBean queryBean, @NonNull String tag) {
        return Observable.create(e -> {
            try {
                ResourceResponseBean responseBean = super.getResponse(e, queryBean, tag);
                if (responseBean != null) {
                    String messageId = responseBean.getMessageId();
                    List<String> heads = new ArrayList<>();
                    heads.add("messageId : " + messageId);
                    if (responseBean.isSuccess()) {
                        List<ResourceResponseBean.DataBean.DataListBean> dataList = responseBean.getData().getDataList();
                        String response = null;
                        if (dataList != null && dataList.size() > 0) {
                            List<ResourceResponseBean.DataBean.DataListBean.FieldValuesBean> fieldValues = dataList.get(0).getFieldValues();
                            for (ResourceResponseBean.DataBean.DataListBean.FieldValuesBean bean : fieldValues) {
                                if (tag.equals(bean.getField())) {
                                    response = bean.getValue();
                                    break;
                                }
                            }
                            if (response == null) {
                                String errorMessage = "解析字段失败,约定返回为空";
                                DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                                e.onError(new Throwable(errorMessage));
                            } else {
                                DefaultFormatPrinter.printResponse(heads, response, null, tag);
                                e.onNext(response);
                                e.onComplete();
                            }
                        } else {
                            String errorMessage = "解析字段失败,dataList字段为空";
                            DefaultFormatPrinter.printResponse(null, null, errorMessage, tag);
                            e.onError(new Throwable(errorMessage));
                        }
                    } else {
                        dealErrorInfo(e, responseBean,tag);
                    }
                }
            } catch (Throwable throwable) {
                e.onError(throwable);
            }
        });
    }

    private static class Holder {
        private static BaseHttpRequest singleton = new BaseHttpRequest();
    }
}
